/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.consul.ConsulService;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsulUtils {
    public static boolean isSame(List<URL> urls1, List<URL> urls2) {
        if (urls1 == null || urls2 == null) {
            return false;
        }
        if (urls1.size() != urls2.size()) {
            return false;
        }
        return urls1.containsAll(urls2);
    }

    public static ConsulService buildService(URL url) {
        ConsulService service = new ConsulService();
        service.setAddress(url.getHost());
        service.setId(ConsulUtils.convertConsulSerivceId(url));
        service.setName(url.getPath());
        service.setPort(url.getPort());
        ArrayList<String> tags = new ArrayList<String>();
        String env = url.getParameter("environment");
        if (env != null) {
            tags.add(env);
        }
        service.setTags(tags);
        return service;
    }

    public static URL buildUrl(ConsulService service) {
        URLImpl url = null;
        if (url == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            url = new URLImpl("http", service.getAddress(), service.getPort(), ConsulUtils.getPathFromServiceId(service.getId()), params);
        }
        return url;
    }

    public static String getUrlClusterInfo(URL url) {
        return url.getPath();
    }

    public static String convertGroupToServiceName(String group) {
        return group;
    }

    public static String getGroupFromServiceName(String group) {
        return group;
    }

    public static String convertConsulSerivceId(URL url) {
        if (url == null) {
            return null;
        }
        return ConsulUtils.convertServiceId(url.getHost(), url.getPort(), url.getPath());
    }

    public static String getPathFromServiceId(String serviceId) {
        return serviceId.substring(serviceId.indexOf(":") + 1, serviceId.lastIndexOf(":"));
    }

    public static String getProtocolFromTag(String tag) {
        return tag.substring("protocol_".length());
    }

    public static String convertServiceId(String host, int port, String path) {
        return host + ":" + path + ":" + port;
    }
}

