/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cors;

import com.networknt.cors.CorsHeaders;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.NetworkUtils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsUtil {
    private static final Logger logger = LoggerFactory.getLogger(CorsUtil.class);

    public static boolean isCoreRequest(HeaderMap headers) {
        return headers.contains(CorsHeaders.ORIGIN) || headers.contains(CorsHeaders.ACCESS_CONTROL_REQUEST_HEADERS) || headers.contains(CorsHeaders.ACCESS_CONTROL_REQUEST_METHOD);
    }

    public static String matchOrigin(HttpServerExchange exchange, Collection<String> allowedOrigins) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        String[] origins = headers.get(Headers.ORIGIN).toArray();
        if (allowedOrigins != null && !allowedOrigins.isEmpty()) {
            for (String allowedOrigin : allowedOrigins) {
                String[] stringArray = origins;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String origin = stringArray[i];
                    if (!allowedOrigin.equalsIgnoreCase(CorsUtil.sanitizeDefaultPort(origin))) continue;
                    return allowedOrigin;
                }
            }
        }
        String allowedOrigin = CorsUtil.defaultOrigin(exchange);
        for (String origin : origins) {
            if (!allowedOrigin.equalsIgnoreCase(CorsUtil.sanitizeDefaultPort(origin))) continue;
            return allowedOrigin;
        }
        logger.debug("Request rejected due to HOST/ORIGIN mis-match.");
        ResponseCodeHandler.HANDLE_403.handleRequest(exchange);
        return null;
    }

    public static String defaultOrigin(HttpServerExchange exchange) {
        String host = NetworkUtils.formatPossibleIpv6Address(exchange.getHostName());
        String protocol = exchange.getRequestScheme();
        int port = exchange.getHostPort();
        StringBuilder allowedOrigin = new StringBuilder(256);
        allowedOrigin.append(protocol).append("://").append(host);
        if (!CorsUtil.isDefaultPort(port, protocol)) {
            allowedOrigin.append(':').append(port);
        }
        return allowedOrigin.toString();
    }

    private static boolean isDefaultPort(int port, String protocol) {
        return "http".equals(protocol) && 80 == port || "https".equals(protocol) && 443 == port;
    }

    public static String sanitizeDefaultPort(String url) {
        int port;
        int portIndex;
        int afterSchemeIndex = url.indexOf("://");
        if (afterSchemeIndex < 0) {
            return url;
        }
        String scheme = url.substring(0, afterSchemeIndex);
        int fromIndex = scheme.length() + 3;
        int ipv6StartIndex = url.indexOf(91, fromIndex);
        if (ipv6StartIndex > 0) {
            fromIndex = url.indexOf(93, ipv6StartIndex);
        }
        if ((portIndex = url.indexOf(58, fromIndex)) >= 0 && CorsUtil.isDefaultPort(port = Integer.parseInt(url.substring(portIndex + 1)), scheme)) {
            return url.substring(0, portIndex);
        }
        return url;
    }

    public static boolean isPreflightedRequest(HttpServerExchange exchange) {
        return Methods.OPTIONS.equals(exchange.getRequestMethod()) && CorsUtil.isCoreRequest(exchange.getRequestHeaders());
    }
}

