/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.jsonoverlay.Overlay;
import com.networknt.jsonoverlay.PropertiesOverlay;
import com.networknt.oas.model.Example;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Schema;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.impl.ExampleValidator;
import com.networknt.oas.validator.impl.MediaTypeValidator;
import com.networknt.oas.validator.impl.OpenApi3Messages;
import com.networknt.oas.validator.impl.Regexes;
import com.networknt.oas.validator.impl.SchemaValidator;
import com.networknt.oas.validator.msg.Messages;
import java.util.Map;
import java.util.function.Consumer;

public class ParameterValidator
extends ObjectValidatorBase<Parameter> {
    @Override
    public void runObjectValidations() {
        Parameter parameter = (Parameter)((Object)this.value.getOverlay());
        this.validateStringField("description", false);
        this.validateBooleanField("deprecated", false);
        this.validateBooleanField("allowEmptyValue", false);
        this.validateBooleanField("explode", false);
        Overlay<Object> example = this.validateField("example", false, Object.class, null, new Consumer[0]);
        Overlay<Map<String, Example>> examples = this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        this.checkExampleExclusion(examples, example);
        this.validateStringField("name", true);
        this.validateStringField("in", true, Regexes.PARAM_IN_REGEX, new Consumer[0]);
        this.checkPathParam(parameter);
        this.checkRequired(parameter);
        this.validateStringField("style", false, Regexes.STYLE_REGEX, new Consumer[0]);
        this.checkAllowReserved(parameter);
        this.validateField("schema", false, Schema.class, new SchemaValidator(), new Consumer[0]);
        this.validateMapField("contentMediaTypes", false, false, MediaType.class, new MediaTypeValidator());
        this.validateExtensions(parameter.getExtensions());
    }

    private void checkPathParam(Parameter parameter) {
        if (parameter.getIn() != null && parameter.getIn().equals("path") && parameter.getName() != null) {
            String path = this.getPathString(parameter);
            if (path != null) {
                if (!path.matches(".*/\\{" + parameter.getName() + "\\}(/.*)?")) {
                    this.results.addError(Messages.msg(OpenApi3Messages.MissingPathTplt, parameter.getName(), path), this.value);
                }
            } else {
                this.results.addWarning(Messages.msg(OpenApi3Messages.NoPath, parameter.getName(), parameter.getIn()), this.value);
            }
        }
    }

    private void checkRequired(Parameter parameter) {
        if ("path".equals(parameter.getIn()) && parameter.getRequired() != Boolean.TRUE) {
            this.results.addError(Messages.msg(OpenApi3Messages.PathParamReq, parameter.getName()), this.value);
        }
    }

    private void checkAllowReserved(Parameter parameter) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn())) {
            this.results.addWarning(Messages.msg(OpenApi3Messages.NonQryAllowRsvd, parameter.getName(), parameter.getIn()), this.value);
        }
    }

    private String getPathString(Parameter parameter) {
        PropertiesOverlay<?> parent = Overlay.of(parameter).getParentPropertiesOverlay();
        while (parent != null && !(parent instanceof Path)) {
            parent = Overlay.of(parent).getParentPropertiesOverlay();
        }
        return parent != null && parent instanceof Path ? Overlay.getPathInParent(parent) : null;
    }

    void checkExampleExclusion(Overlay<Map<String, Example>> examples, Overlay<Object> example) {
        boolean examplePresent;
        boolean examplesPresent = examples != null && examples.isPresent() && Overlay.getMapOverlay(examples).size() > 0;
        boolean bl = examplePresent = example != null && example.isPresent();
        if (examplesPresent && examplePresent) {
            this.results.addError("ExmplExclusion|The 'example' and 'exmaples' properties may not both appear", this.value);
        }
    }
}

