/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.audit.AuditHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(OpenApiHandler.class);
    public static final String CONFIG_NAME = "openapi";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    private volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String httpMethod;
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        Optional<NormalisedPath> maybeApiPath = OpenApiHelper.findMatchingApiPath(requestPath);
        if (!maybeApiPath.isPresent()) {
            this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, requestPath.normalised());
            return;
        }
        NormalisedPath openApiPathString = maybeApiPath.get();
        Path path = OpenApiHelper.openApi3.getPath(openApiPathString.original());
        Operation operation = path.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
        if (operation == null) {
            this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
            return;
        }
        OpenApiOperation openApiOperation = new OpenApiOperation(openApiPathString, path, httpMethod, operation);
        String endpoint = openApiPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
        HashMap<String, Object> auditInfo = new HashMap<String, Object>();
        auditInfo.put("endpoint", endpoint);
        auditInfo.put("openapi_operation", openApiOperation);
        exchange.putAttachment(AuditHandler.AUDIT_INFO, auditInfo);
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return OpenApiHelper.openApi3 != null;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(OpenApiHandler.class.getName(), Config.getInstance().getJsonMapConfig(CONFIG_NAME), null);
    }
}

