/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.body.BodyHandler;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.RequestBody;
import com.networknt.oas.model.impl.RequestBodyImpl;
import com.networknt.oas.model.impl.SchemaImpl;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorHandler;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    static final Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    static final String VALIDATOR_REQUEST_BODY_UNEXPECTED = "ERR11013";
    static final String VALIDATOR_REQUEST_BODY_MISSING = "ERR11014";
    static final String VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING = "ERR11017";
    static final String VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING = "ERR11000";
    private final SchemaValidator schemaValidator;

    public RequestValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
    }

    public Status validateRequest(NormalisedPath requestPath, HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Objects.requireNonNull(requestPath, "A request path is required");
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(openApiOperation, "An OpenAPI operation is required");
        Status status = this.validatePathParameters(requestPath, openApiOperation);
        if (status != null) {
            return status;
        }
        status = this.validateQueryParameters(exchange, openApiOperation);
        if (status != null) {
            return status;
        }
        status = this.validateHeader(exchange, openApiOperation);
        if (status != null) {
            return status;
        }
        Object body = exchange.getAttachment(BodyHandler.REQUEST_BODY);
        if (body == null && ValidatorHandler.config.skipBodyValidation) {
            return null;
        }
        status = this.validateRequestBody(body, openApiOperation);
        return status;
    }

    private Status validateRequestBody(Object requestBody, OpenApiOperation openApiOperation) {
        RequestBody specBody = openApiOperation.getOperation().getRequestBody();
        if (requestBody != null && specBody == null) {
            return new Status(VALIDATOR_REQUEST_BODY_UNEXPECTED, openApiOperation.getMethod(), openApiOperation.getPathString().original());
        }
        if (specBody == null || !Overlay.isPresent((RequestBodyImpl)specBody)) {
            return null;
        }
        if (requestBody == null) {
            if (specBody.getRequired() != null && specBody.getRequired().booleanValue()) {
                if (BodyHandler.config.isEnabled()) {
                    return new Status(VALIDATOR_REQUEST_BODY_MISSING, openApiOperation.getMethod(), openApiOperation.getPathString().original());
                }
                logger.warn("Body object doesn't exist in exchange attachment. Most likely the BodyHandler is not in the request chain before RequestValidator or reqeust misses application/json content type header");
            }
            return null;
        }
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(false);
        return this.schemaValidator.validate(requestBody, Overlay.toJson((SchemaImpl)specBody.getContentMediaType("application/json").getSchema()), config);
    }

    private Status validatePathParameters(NormalisedPath requestPath, OpenApiOperation openApiOperation) {
        Status status = null;
        for (int i = 0; i < openApiOperation.getPathString().parts().size(); ++i) {
            if (!openApiOperation.getPathString().isParam(i)) continue;
            String paramName = openApiOperation.getPathString().paramName(i);
            String paramValue = requestPath.part(i);
            try {
                paramValue = URLDecoder.decode(requestPath.part(i), "UTF-8");
            }
            catch (Exception e) {
                logger.info("Path parameter cannot be decoded, it will be used directly");
            }
            Optional<Parameter> parameter = openApiOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("PATH")).filter(p -> p.getName().equalsIgnoreCase(paramName)).findFirst();
            if (!parameter.isPresent()) continue;
            return this.schemaValidator.validate(paramValue, Overlay.toJson((SchemaImpl)parameter.get().getSchema()));
        }
        return status;
    }

    private Status validateQueryParameters(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Optional<Status> optional = openApiOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("QUERY")).map(p -> this.validateQueryParameter(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Status validateQueryParameter(HttpServerExchange exchange, OpenApiOperation openApiOperation, Parameter queryParameter) {
        Collection queryParameterValues = exchange.getQueryParameters().get(queryParameter.getName());
        if (queryParameterValues == null || queryParameterValues.isEmpty()) {
            if (queryParameter.getRequired().booleanValue()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING, queryParameter.getName(), openApiOperation.getPathString().original());
            }
        } else if (queryParameterValues.size() < 2) {
            Optional<Status> optional = queryParameterValues.stream().map(v -> this.schemaValidator.validate(v, Overlay.toJson((SchemaImpl)queryParameter.getSchema()))).filter(s -> s != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        } else {
            Status status = this.schemaValidator.validate(queryParameterValues, Overlay.toJson((SchemaImpl)queryParameter.getSchema()));
            Optional<Status> optional = Optional.ofNullable(status);
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }

    private Status validateHeader(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Optional<Status> optional = openApiOperation.getPathObject().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("header")).map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = openApiOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("header")).map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Status validateHeader(HttpServerExchange exchange, OpenApiOperation openApiOperation, Parameter headerParameter) {
        HeaderValues headerValues = exchange.getRequestHeaders().get(headerParameter.getName());
        if (headerValues == null || headerValues.isEmpty()) {
            if (headerParameter.getRequired().booleanValue()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING, headerParameter.getName(), openApiOperation.getPathString().original());
            }
        } else {
            Optional<Status> optional = headerValues.stream().map(v -> this.schemaValidator.validate(v, Overlay.toJson((SchemaImpl)headerParameter.getSchema()))).filter(s -> s != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }
}

