/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.audit.AuditHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.RequestValidator;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorHandler
implements MiddlewareHandler {
    public static final String OPENAPI_CONFIG_NAME = "openapi-validator";
    public static final String CONFIG_NAME = "validator";
    static final String STATUS_MISSING_OPENAPI_OPERATION = "ERR10012";
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    static ValidatorConfig config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig("openapi-validator", ValidatorConfig.class);
    private volatile HttpHandler next;
    RequestValidator requestValidator;

    public ValidatorHandler() {
        SchemaValidator schemaValidator = new SchemaValidator(OpenApiHelper.openApi3);
        this.requestValidator = new RequestValidator(schemaValidator);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        OpenApiOperation openApiOperation = null;
        Map auditInfo = exchange.getAttachment(AuditHandler.AUDIT_INFO);
        if (auditInfo != null) {
            openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation");
        }
        if (openApiOperation == null) {
            this.setExchangeStatus(exchange, STATUS_MISSING_OPENAPI_OPERATION, new Object[0]);
            return;
        }
        Status status = this.requestValidator.validateRequest(requestPath, exchange, openApiOperation);
        if (status != null) {
            exchange.setStatusCode(status.getStatusCode());
            status.setDescription(status.getDescription().replaceAll("\\\\", "\\\\\\\\"));
            exchange.getResponseSender().send(status.toString());
            if (ValidatorHandler.config.logError) {
                logger.error("ValidationError:" + status.toString());
            }
            return;
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ValidatorHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(OPENAPI_CONFIG_NAME), null);
    }

    static {
        if (config == null) {
            config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ValidatorConfig.class);
        }
    }
}

