/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support;

import com.networknt.exception.FrameworkException;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.support.AbstractRegistry;
import com.networknt.status.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DirectRegistry
extends AbstractRegistry {
    private static final String PARSE_DIRECT_URL_ERROR = "ERR10019";
    private ConcurrentHashMap<URL, Object> subscribeUrls = new ConcurrentHashMap();
    private Map<String, List<URL>> directUrls = new HashMap<String, List<URL>>();

    public DirectRegistry(URL url) {
        super(url);
        for (Map.Entry<String, String> entry : url.getParameters().entrySet()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                if (entry.getValue().contains(",")) {
                    String[] directUrlArray;
                    for (String directUrl : directUrlArray = entry.getValue().split(",")) {
                        urls.add(URLImpl.valueOf(directUrl + "/" + entry.getKey()));
                    }
                } else {
                    urls.add(URLImpl.valueOf(entry.getValue() + "/" + entry.getKey()));
                }
            }
            catch (Exception e) {
                throw new FrameworkException(new Status(PARSE_DIRECT_URL_ERROR, url.toString()));
            }
            this.directUrls.put(entry.getKey(), urls);
        }
    }

    @Override
    protected void doRegister(URL url) {
    }

    @Override
    protected void doUnregister(URL url) {
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.putIfAbsent(url, 1);
        listener.notify(this.getUrl(), this.doDiscover(url));
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.remove(url);
        listener.notify(this.getUrl(), this.doDiscover(url));
    }

    @Override
    protected List<URL> doDiscover(URL subscribeUrl) {
        return this.createSubscribeUrl(subscribeUrl);
    }

    private List<URL> createSubscribeUrl(URL subscribeUrl) {
        String serviceName = subscribeUrl.getPath();
        return this.directUrls.get(serviceName);
    }

    @Override
    protected void doAvailable(URL url) {
    }

    @Override
    protected void doUnavailable(URL url) {
    }
}

