/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.resource;

import com.networknt.resource.PathResourceProvider;
import com.networknt.resource.PredicatedHandlersProvider;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import java.util.ArrayList;
import java.util.List;

public class ResourceHelpers {
    public static void addProvidersToPathHandler(PathResourceProvider[] pathResourceProviders, PathHandler pathHandler) {
        if (pathResourceProviders != null && pathResourceProviders.length > 0) {
            for (PathResourceProvider pathResourceProvider : pathResourceProviders) {
                if (pathResourceProvider.isPrefixPath().booleanValue()) {
                    pathHandler.addPrefixPath(pathResourceProvider.getPath(), new ResourceHandler(pathResourceProvider.getResourceManager()));
                    continue;
                }
                pathHandler.addExactPath(pathResourceProvider.getPath(), new ResourceHandler(pathResourceProvider.getResourceManager()));
            }
        }
    }

    public static List<PredicatedHandler> getPredicatedHandlers(PredicatedHandlersProvider[] predicatedHandlersProviders) {
        ArrayList<PredicatedHandler> predicatedHandlers = new ArrayList<PredicatedHandler>();
        if (predicatedHandlersProviders != null && predicatedHandlersProviders.length > 0) {
            for (PredicatedHandlersProvider predicatedHandlersProvider : predicatedHandlersProviders) {
                predicatedHandlers.addAll(predicatedHandlersProvider.getPredicatedHandlers());
            }
        }
        return predicatedHandlers;
    }

    public static boolean isResourcePath(String requestPath, PathResourceProvider[] pathResourceProviders) {
        boolean isResourcePath = false;
        if (pathResourceProviders != null && pathResourceProviders.length > 0) {
            for (PathResourceProvider pathResourceProvider : pathResourceProviders) {
                if ((!pathResourceProvider.isPrefixPath().booleanValue() || !requestPath.startsWith(pathResourceProvider.getPath())) && (pathResourceProvider.isPrefixPath().booleanValue() || !requestPath.equals(pathResourceProvider.getPath()))) continue;
                isResourcePath = true;
            }
        }
        return isResourcePath;
    }
}

