/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.router.RouterConfig;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingRouterProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import org.xnio.OptionMap;

public class RouterHandler
implements HttpHandler {
    static final String CONFIG_NAME = "router";
    static RouterConfig config = (RouterConfig)Config.getInstance().getJsonObjectConfig("router", RouterConfig.class);
    ProxyHandler proxyHandler;

    public RouterHandler() {
        LoadBalancingRouterProxyClient client = new LoadBalancingRouterProxyClient();
        if (RouterHandler.config.httpsEnabled) {
            client.setSsl(Http2Client.SSL);
        }
        if (RouterHandler.config.http2Enabled) {
            client.setOptionMap(OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
        } else {
            client.setOptionMap(OptionMap.EMPTY);
        }
        this.proxyHandler = ProxyHandler.builder().setProxyClient(client).setMaxConnectionRetries(RouterHandler.config.maxConnectionRetries).setMaxRequestTime(RouterHandler.config.maxRequestTime).setReuseXForwarded(RouterHandler.config.reuseXForwarded).setRewriteHostHeader(RouterHandler.config.rewriteHostHeader).setNext(ResponseCodeHandler.HANDLE_404).build();
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.proxyHandler.handleRequest(httpServerExchange);
    }
}

