/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.client.Http2Client;
import com.networknt.cluster.Cluster;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class RouterProxyClient
implements ProxyClient {
    static Map<String, ClientConnection> connectionMap = new CopyOnWriteMap<String, ClientConnection>();
    static Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
    static Logger logger = LoggerFactory.getLogger(RouterProxyClient.class);
    private final Http2Client client = Http2Client.getInstance();
    private static final ProxyClient.ProxyTarget PROXY_TARGET = new ProxyClient.ProxyTarget(){};

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange httpServerExchange) {
        return PROXY_TARGET;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        HeaderMap headers = exchange.getRequestHeaders();
        String serviceId = headers.getFirst(HttpStringConstants.SERVICE_ID);
        String envTag = headers.getFirst(HttpStringConstants.ENV_TAG);
        String key = serviceId + envTag;
        ClientConnection existing = connectionMap.get(key);
        if (existing != null) {
            if (existing.isOpen()) {
                callback.completed(exchange, new ProxyConnection(existing, "/"));
                return;
            }
            connectionMap.remove(key);
        }
        String host = cluster.serviceToUrl("https", serviceId, envTag, null);
        try {
            this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(callback, exchange), new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI:" + host, e);
        }
    }

    private static final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final ProxyCallback<ProxyConnection> callback;
        private final HttpServerExchange exchange;

        private ConnectNotifier(ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void completed(ClientConnection connection) {
            if (logger.isDebugEnabled()) {
                logger.debug("ConnectNotifier completed is called with connection " + connection);
            }
            HeaderMap headers = this.exchange.getRequestHeaders();
            String serviceId = headers.getFirst(HttpStringConstants.SERVICE_ID);
            String envTag = headers.getFirst(HttpStringConstants.ENV_TAG);
            String key = serviceId + envTag;
            connectionMap.put(key, connection);
            this.callback.completed(this.exchange, new ProxyConnection(connection, "/"));
        }

        @Override
        public void failed(IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("ConnectNotifier failed is called with exception", e);
            }
            this.callback.failed(this.exchange);
        }
    }
}

