/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLTokenHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "token";
    public static final String CLIENT_CONFIG_NAME = "client";
    public static final String ENABLED = "enabled";
    public static final String CONFIG_SECURITY = "security";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("token");
    static Logger logger = LoggerFactory.getLogger(SAMLTokenHandler.class);
    private volatile HttpHandler next;
    static final String OAUTH = "oauth";
    static final String TOKEN = "token";
    static final String OAUTH_HTTP2_SUPPORT = "oauthHttp2Support";
    static final String SAMLAssertionHeader = "assertion";
    static final String JWTAssertionHeader = "client_assertion";
    static final String STATUS_SAMLBEARER_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    static Map<String, Object> clientConfig;
    static Map<String, Object> tokenConfig;
    static Map<String, Object> secretConfig;
    static boolean oauthHttp2Support;
    private final Object lock = new Object();

    public SAMLTokenHandler() {
        Map<String, Object> secretMap;
        Map<String, Object> securityConfig;
        Map oauthConfig;
        clientConfig = Config.getInstance().getJsonMapConfig(CLIENT_CONFIG_NAME);
        if (clientConfig != null && (oauthConfig = (Map)clientConfig.get(OAUTH)) != null) {
            tokenConfig = (Map)oauthConfig.get("token");
        }
        if ((securityConfig = Config.getInstance().getJsonMapConfig(CONFIG_SECURITY)) != null) {
            Boolean b = (Boolean)securityConfig.get(OAUTH_HTTP2_SUPPORT);
            boolean bl = oauthHttp2Support = b == null ? false : b;
        }
        if ((secretMap = Config.getInstance().getJsonMapConfig("secret")) == null) {
            throw new ExceptionInInitializerError("Could not locate secret.yml");
        }
        secretConfig = DecryptUtil.decryptMap(secretMap);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        logger.debug(exchange.toString());
        Result<String> result = this.getSAMLBearerToken(exchange.getRequestHeaders().getFirst(SAMLAssertionHeader), exchange.getRequestHeaders().getFirst(JWTAssertionHeader));
        if (result.isFailure()) {
            OauthHelper.sendStatusToResponse(exchange, result.getError());
            return;
        }
        exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + result.getResult());
        exchange.getRequestHeaders().remove(SAMLAssertionHeader);
        exchange.getRequestHeaders().remove(JWTAssertionHeader);
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(SAMLTokenHandler.class.getName(), config, null);
    }

    private Result<String> getSAMLBearerToken(String samlAssertion, String jwtAssertion) {
        SAMLBearerRequest tokenRequest = new SAMLBearerRequest(samlAssertion, jwtAssertion);
        Result<TokenResponse> tokenResponse = OauthHelper.getTokenFromSamlResult(tokenRequest);
        if (tokenResponse.isSuccess()) {
            String jwt = tokenResponse.getResult().getAccessToken();
            logger.debug("SAMLBearer Grant Type jwt: ", (Object)jwt);
            return Success.of(jwt);
        }
        return Failure.of(tokenResponse.getError());
    }
}

