/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.monad.Result;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "token";
    public static final String ENABLED = "enabled";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("token");
    static Logger logger = LoggerFactory.getLogger(TokenHandler.class);
    private volatile HttpHandler next;
    private final Jwt cachedJwt = new Jwt();

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Result<Jwt> result = OauthHelper.populateCCToken(this.cachedJwt);
        if (result.isFailure()) {
            logger.error("cannot populate or renew jwt for client credential grant type");
            OauthHelper.sendStatusToResponse(exchange, result.getError());
            return;
        }
        exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + this.cachedJwt.getJwt());
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(TokenHandler.class.getName(), config, null);
    }
}

