/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.config.Config;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.utility.FingerPrintUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtHelper {
    static final Logger logger = LoggerFactory.getLogger(JwtHelper.class);
    public static final String KID = "kid";
    public static final String JWT_CONFIG = "jwt";
    public static final String SECURITY_CONFIG = "security";
    public static final String JWT_CERTIFICATE = "certificate";
    public static final String JWT_CLOCK_SKEW_IN_SECONDS = "clockSkewInSeconds";
    public static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    private static final String ENABLE_JWT_CACHE = "enableJwtCache";
    private static final String BOOTSTRAP_FROM_KEY_SERVICE = "bootstrapFromKeyService";
    private static final int CACHE_EXPIRED_IN_MINUTES = 15;
    static Map<String, X509Certificate> certMap;
    static List<String> fingerPrints;
    static Map<String, Object> securityConfig;
    static Map<String, Object> securityJwtConfig;
    static int secondsOfAllowedClockSkew;
    static Boolean enableJwtCache;
    static Boolean bootstrapFromKeyService;
    static Cache<String, JwtClaims> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readCertificate(String filename) throws Exception {
        InputStream inStream = null;
        X509Certificate cert = null;
        try {
            inStream = Config.getInstance().getInputStreamFromFile(filename);
            if (inStream != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(inStream);
            } else {
                logger.info("Certificate " + Encode.forJava(filename) + " not found.");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {
                    logger.error("Exception: ", ioe);
                }
            }
        }
        return cert;
    }

    public static String getJwtFromAuthorization(String authorization) {
        String[] parts;
        String jwt = null;
        if (authorization != null && (parts = authorization.split(" ")).length == 2) {
            String scheme = parts[0];
            String credentials = parts[1];
            Pattern pattern = Pattern.compile("^Bearer$", 2);
            if (pattern.matcher(scheme).matches()) {
                jwt = credentials;
            }
        }
        return jwt;
    }

    public static JwtClaims verifyJwt(String jwt, boolean ignoreExpiry) throws InvalidJwtException, ExpiredTokenException {
        X509Certificate certificate;
        JwtClaims claims;
        if (Boolean.TRUE.equals(enableJwtCache) && (claims = cache.getIfPresent(jwt)) != null) {
            if (!ignoreExpiry) {
                try {
                    if (NumericDate.now().getValue() - (long)secondsOfAllowedClockSkew >= claims.getExpirationTime().getValue()) {
                        logger.info("Cached jwt token is expired!");
                        throw new ExpiredTokenException("Token is expired");
                    }
                }
                catch (MalformedClaimException e) {
                    logger.error("MalformedClaimException:", e);
                }
            }
            return claims;
        }
        JwtConsumer consumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        JwtContext jwtContext = consumer.process(jwt);
        claims = jwtContext.getJwtClaims();
        JsonWebStructure structure = jwtContext.getJoseObjects().get(0);
        String kid = structure.getKeyIdHeaderValue();
        if (!ignoreExpiry) {
            try {
                if (NumericDate.now().getValue() - (long)secondsOfAllowedClockSkew >= claims.getExpirationTime().getValue()) {
                    logger.info("jwt token is expired!");
                    throw new ExpiredTokenException("Token is expired");
                }
            }
            catch (MalformedClaimException e) {
                logger.error("MalformedClaimException:", e);
                throw new InvalidJwtException("MalformedClaimException", new ErrorCodeValidator.Error(18, "Invalid ExpirationTime Format"), e, jwtContext);
            }
        }
        X509Certificate x509Certificate = certificate = certMap == null ? null : certMap.get(kid);
        if (certificate == null) {
            certificate = JwtHelper.getCertFromOauth(kid);
            if (certMap == null) {
                certMap = new HashMap<String, X509Certificate>();
            }
            certMap.put(kid, certificate);
        }
        X509VerificationKeyResolver x509VerificationKeyResolver = new X509VerificationKeyResolver(certificate);
        x509VerificationKeyResolver.setTryAllOnNoThumbHeader(true);
        consumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(315360000).setSkipDefaultAudienceValidation().setVerificationKeyResolver(x509VerificationKeyResolver).build();
        jwtContext = consumer.process(jwt);
        claims = jwtContext.getJwtClaims();
        if (Boolean.TRUE.equals(enableJwtCache)) {
            cache.put(jwt, claims);
        }
        return claims;
    }

    public static X509Certificate getCertFromOauth(String kid) {
        X509Certificate certificate = null;
        KeyRequest keyRequest = new KeyRequest(kid);
        try {
            String key = OauthHelper.getKey(keyRequest);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            throw new RuntimeException(e);
        }
        return certificate;
    }

    public static List getFingerPrints() {
        return fingerPrints;
    }

    static {
        securityConfig = Config.getInstance().getJsonMapConfig(SECURITY_CONFIG);
        securityJwtConfig = (Map)securityConfig.get(JWT_CONFIG);
        secondsOfAllowedClockSkew = (Integer)securityJwtConfig.get(JWT_CLOCK_SKEW_IN_SECONDS);
        enableJwtCache = (Boolean)securityConfig.get(ENABLE_JWT_CACHE);
        bootstrapFromKeyService = (Boolean)securityConfig.get(BOOTSTRAP_FROM_KEY_SERVICE);
        if (Boolean.TRUE.equals(enableJwtCache)) {
            cache = Caffeine.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
        }
        if (bootstrapFromKeyService == null || Boolean.FALSE.equals(bootstrapFromKeyService)) {
            certMap = new HashMap<String, X509Certificate>();
            fingerPrints = new ArrayList<String>();
            Map keyMap = (Map)securityJwtConfig.get(JWT_CERTIFICATE);
            for (String kid : keyMap.keySet()) {
                X509Certificate cert = null;
                try {
                    cert = JwtHelper.readCertificate((String)keyMap.get(kid));
                }
                catch (Exception e) {
                    logger.error("Exception:", e);
                }
                certMap.put(kid, cert);
                fingerPrints.add(FingerPrintUtil.getCertFingerPrint(cert));
            }
        }
    }
}

