/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.status;

import com.networknt.config.Config;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.StatusSerializer;
import com.networknt.utility.ModuleRegistry;
import java.util.IllegalFormatException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status {
    private static final Logger logger = LoggerFactory.getLogger(Status.class);
    public static final String CONFIG_NAME = "status";
    public static final Map<String, Object> config = Config.getInstance().getJsonMapConfig("status");
    public static final String defaultSeverity = "ERROR";
    private static StatusSerializer statusSerializer;
    private int statusCode;
    private String code;
    private String severity;
    private String message;
    private String description;

    public Status() {
    }

    public Status(String code, Object ... args) {
        this.code = code;
        Map map = (Map)config.get(code);
        if (map != null) {
            this.statusCode = (Integer)map.get("statusCode");
            this.message = (String)map.get("message");
            this.description = (String)map.get("description");
            try {
                this.description = String.format(this.description, args);
            }
            catch (IllegalFormatException e) {
                logger.warn(String.format("Error formatting description of status %s", code), e);
            }
            this.severity = (String)map.get("severity");
            if (this.severity == null) {
                this.severity = defaultSeverity;
            }
        }
    }

    public Status(int statusCode, String code, String message, String description) {
        this.statusCode = statusCode;
        this.code = code;
        this.severity = defaultSeverity;
        this.message = message;
        this.description = description;
    }

    public Status(int statusCode, String code, String message, String description, String severity) {
        this.statusCode = statusCode;
        this.code = code;
        this.severity = severity;
        this.message = message;
        this.description = description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String toString() {
        if (statusSerializer != null) {
            return statusSerializer.serializeStatus(this);
        }
        return "{\"statusCode\":" + this.getStatusCode() + ",\"code\":\"" + this.getCode() + "\",\"message\":\"" + this.getMessage() + "\",\"description\":\"" + this.getDescription() + "\",\"severity\":\"" + this.getSeverity() + "\"}";
    }

    static {
        ModuleRegistry.registerModule(Status.class.getName(), config, null);
        try {
            statusSerializer = SingletonServiceFactory.getBean(StatusSerializer.class);
        }
        catch (ExceptionInInitializerError e) {
            statusSerializer = null;
        }
    }
}

