/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.HistogramSnapshot;
import io.dropwizard.metrics.Reservoir;
import io.dropwizard.metrics.Snapshot;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

@ThreadSafe
public final class HdrHistogramResetOnSnapshotReservoir
implements Reservoir {
    private final Recorder recorder;
    @Nonnull
    @GuardedBy(value="this")
    private Histogram intervalHistogram;

    public HdrHistogramResetOnSnapshotReservoir() {
        this(new Recorder(2));
    }

    public HdrHistogramResetOnSnapshotReservoir(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
    }

    @Override
    public int size() {
        return this.getSnapshot().size();
    }

    @Override
    public void update(long value) {
        this.recorder.recordValue(value);
    }

    @Override
    public Snapshot getSnapshot() {
        return new HistogramSnapshot(this.getDataSinceLastSnapshotAndReset());
    }

    @Nonnull
    private synchronized Histogram getDataSinceLastSnapshotAndReset() {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        return this.intervalHistogram.copy();
    }
}

