/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class MetricName
implements Comparable<MetricName> {
    public static final String SEPARATOR = ".";
    public static final Map<String, String> EMPTY_TAGS = Collections.unmodifiableMap(new HashMap());
    public static final MetricName EMPTY = new MetricName();
    private final String key;
    private final Map<String, String> tags;

    public MetricName() {
        this.key = null;
        this.tags = EMPTY_TAGS;
    }

    public MetricName(String key) {
        this.key = key;
        this.tags = EMPTY_TAGS;
    }

    public MetricName(String key, Map<String, String> tags) {
        this.key = key;
        this.tags = this.checkTags(tags);
    }

    private Map<String, String> checkTags(Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return EMPTY_TAGS;
        }
        return Collections.unmodifiableMap(tags);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricName resolve(String p) {
        String next = p != null && !p.isEmpty() ? (this.key != null && !this.key.isEmpty() ? this.key + SEPARATOR + p : p) : this.key;
        return new MetricName(next, this.tags);
    }

    public MetricName tagged(Map<String, String> add) {
        HashMap<String, String> tags = new HashMap<String, String>(add);
        tags.putAll(this.tags);
        return new MetricName(this.key, tags);
    }

    public MetricName tagged(String ... pairs) {
        if (pairs == null) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Argument count must be even");
        }
        HashMap<String, String> add = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            add.put(pairs[i], pairs[i + 1]);
        }
        return this.tagged(add);
    }

    public static MetricName join(MetricName ... parts) {
        StringBuilder nameBuilder = new StringBuilder();
        HashMap<String, String> tags = new HashMap<String, String>();
        boolean first = true;
        for (MetricName part : parts) {
            String name = part.getKey();
            if (name != null && !name.isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    nameBuilder.append(SEPARATOR);
                }
                nameBuilder.append(name);
            }
            if (part.getTags().isEmpty()) continue;
            tags.putAll(part.getTags());
        }
        return new MetricName(nameBuilder.toString(), tags);
    }

    public static MetricName build(String ... parts) {
        if (parts == null || parts.length == 0) {
            return EMPTY;
        }
        if (parts.length == 1) {
            return new MetricName(parts[0], EMPTY_TAGS);
        }
        return new MetricName(MetricName.buildName(parts), EMPTY_TAGS);
    }

    private static String buildName(String ... names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(SEPARATOR);
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public String toString() {
        if (this.tags.isEmpty()) {
            return this.key;
        }
        return this.key + this.tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricName other = (MetricName)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.tags.equals(other.tags);
    }

    @Override
    public int compareTo(@Nonnull MetricName o) {
        if (o == null) {
            return -1;
        }
        int c = this.compareName(this.key, o.getKey());
        if (c != 0) {
            return c;
        }
        return this.compareTags(this.tags, o.getTags());
    }

    private int compareName(String left, String right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return left.compareTo(right);
    }

    private int compareTags(Map<String, String> left, Map<String, String> right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        Iterable<String> keys = this.uniqueSortedKeys(left, right);
        for (String key : keys) {
            String a = left.get(key);
            String b = right.get(key);
            if (a == null && b == null) continue;
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int c = a.compareTo(b);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private Iterable<String> uniqueSortedKeys(Map<String, String> left, Map<String, String> right) {
        TreeSet<String> set = new TreeSet<String>(left.keySet());
        set.addAll(right.keySet());
        return set;
    }
}

