/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.audit.AuditConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.mask.Mask;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AuditHandler.class);
    public static final String ENABLED = "enabled";
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMP = "timestamp";
    static final String MASK_KEY = "audit";
    private AuditConfig auditConfig;
    private volatile HttpHandler next;

    public AuditHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("AuditHandler is loaded.");
        }
        this.auditConfig = AuditConfig.load();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean needAuditData;
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        LinkedHashMap<String, Object> auditMap = new LinkedHashMap<String, Object>();
        long start = System.currentTimeMillis();
        auditMap.put(TIMESTAMP, System.currentTimeMillis());
        boolean bl = needAuditData = auditInfo != null && this.auditConfig.hasAuditList();
        if (needAuditData) {
            this.auditFields(auditInfo, auditMap);
        }
        if (this.auditConfig.hasHeaderList()) {
            this.auditHeader(exchange, auditMap);
        }
        if (this.auditConfig.isStatusCode() || this.auditConfig.isResponseTime()) {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                if (this.auditConfig.isStatusCode()) {
                    auditMap.put(STATUS_CODE, exchange1.getStatusCode());
                }
                if (this.auditConfig.isResponseTime()) {
                    auditMap.put(RESPONSE_TIME, System.currentTimeMillis() - start);
                }
                if (auditInfo != null && this.auditConfig.getAuditList() != null && this.auditConfig.getAuditList().size() > 0) {
                    for (String name : this.auditConfig.getAuditList()) {
                        auditMap.putIfAbsent(name, auditInfo.get(name));
                    }
                }
                try {
                    if (this.auditConfig.isAuditOnError()) {
                        if (exchange1.getStatusCode() >= 400) {
                            this.auditConfig.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                        }
                    } else {
                        this.auditConfig.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                nextListener.proceed();
            });
        } else {
            this.auditConfig.getAuditFunc().accept(this.auditConfig.getConfig().getMapper().writeValueAsString(auditMap));
        }
        this.next(exchange);
    }

    private void auditHeader(HttpServerExchange exchange, Map<String, Object> auditMap) {
        for (String name : this.auditConfig.getHeaderList()) {
            String value = exchange.getRequestHeaders().getFirst(name);
            auditMap.put(name, this.auditConfig.isMaskEnabled() ? Mask.maskRegex(value, "requestHeader", name) : value);
        }
    }

    protected void next(HttpServerExchange exchange) throws Exception {
        Handler.next(exchange, this.next);
    }

    private void auditFields(Map<String, Object> auditInfo, Map<String, Object> auditMap) {
        for (String name : this.auditConfig.getAuditList()) {
            Object value = auditInfo.get(name);
            boolean needApplyMask = this.auditConfig.isMaskEnabled() && value instanceof String;
            auditMap.put(name, needApplyMask ? Mask.maskRegex((String)value, MASK_KEY, name) : value);
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = this.auditConfig.getMappedConfig().get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(AuditHandler.class.getName(), this.auditConfig.getMappedConfig(), null);
    }
}

