/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.listener;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public abstract class ByteBufferReadChannelListener
implements ChannelListener<StreamSourceChannel> {
    private final ByteBufferPool bufferPool;
    private List<Byte> result = new ArrayList<Byte>();

    public ByteBufferReadChannelListener(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    channel.getReadSetter().set(this);
                    channel.resumeReads();
                    continue;
                }
                if (r == -1) {
                    this.bufferDone(this.result);
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                ByteBuffer[] buffs = new ByteBuffer[]{buffer};
                for (int i = 0; i < buffs.length; ++i) {
                    ByteBuffer buf = buffs[i];
                    while (buf.hasRemaining()) {
                        this.result.add(buf.get());
                    }
                }
            } while (r > 0);
        }
        catch (IOException var8) {
            this.error(var8);
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    return;
                }
                if (r == -1) {
                    this.bufferDone(this.result);
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                ByteBuffer[] buffs = new ByteBuffer[]{buffer};
                for (int i = 0; i < buffs.length; ++i) {
                    ByteBuffer buf = buffs[i];
                    while (buf.hasRemaining()) {
                        this.result.add(buf.get());
                    }
                }
            } while (r > 0);
        }
        catch (IOException var8) {
            this.error(var8);
        }
        finally {
            resource.close();
        }
    }

    protected abstract void bufferDone(List<Byte> var1);

    protected abstract void error(IOException var1);
}

