/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth.cache;

import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.cache.ICacheStrategy;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;

public class LongestExpireCacheStrategy
implements ICacheStrategy {
    private final PriorityBlockingQueue<LongestExpireCacheKey> expiryQueue;
    private final ConcurrentHashMap<Jwt.Key, Jwt> cachedJwts;
    private int capacity;

    public LongestExpireCacheStrategy(int capacity) {
        this.capacity = capacity;
        Comparator comparator = (o1, o2) -> {
            if (o1.getExpiry() > o2.getExpiry()) {
                return 1;
            }
            if (o1.getExpiry() == o2.getExpiry()) {
                return 0;
            }
            return -1;
        };
        this.expiryQueue = new PriorityBlockingQueue(capacity, comparator);
        this.cachedJwts = new ConcurrentHashMap();
    }

    @Override
    public synchronized void cacheJwt(Jwt.Key cachedKey, Jwt jwt) {
        LongestExpireCacheKey leCachKey = new LongestExpireCacheKey(cachedKey);
        leCachKey.setExpiry(jwt.getExpire());
        if (this.cachedJwts.size() >= this.capacity) {
            if (this.expiryQueue.contains(leCachKey)) {
                this.expiryQueue.remove(leCachKey);
            } else {
                this.cachedJwts.remove(this.expiryQueue.peek().getCacheKey());
                this.expiryQueue.poll();
            }
        } else if (this.expiryQueue.contains(leCachKey)) {
            this.expiryQueue.remove(leCachKey);
        }
        this.expiryQueue.add(leCachKey);
        this.cachedJwts.put(cachedKey, jwt);
    }

    @Override
    public Jwt getCachedJwt(Jwt.Key key) {
        return this.cachedJwts.get(key);
    }

    private static class LongestExpireCacheKey {
        private long expiry;
        private Jwt.Key cacheKey;

        public int hashCode() {
            return this.cacheKey.hashCode();
        }

        public boolean equals(Object obj) {
            return this.cacheKey.equals(obj);
        }

        LongestExpireCacheKey(Jwt.Key key) {
            this.cacheKey = key;
        }

        long getExpiry() {
            return this.expiry;
        }

        void setExpiry(long expiry) {
            this.expiry = expiry;
        }

        Jwt.Key getCacheKey() {
            return this.cacheKey;
        }
    }
}

