/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import com.networknt.utility.StringUtils;
import java.net.Socket;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public enum EndpointIdentificationAlgorithm {
    HTTPS,
    LDAPS,
    APIS;


    public static EndpointIdentificationAlgorithm select(boolean checkIdentity, Set<String> trustedNameSet) {
        if (checkIdentity) {
            if (trustedNameSet.isEmpty()) {
                return HTTPS;
            }
            return APIS;
        }
        return null;
    }

    public static void setup(SSLEngine engine, EndpointIdentificationAlgorithm identityAlg) {
        SSLParameters parameters;
        String existingAlgorithm;
        if (null != engine && null != identityAlg && APIS != identityAlg && StringUtils.isBlank(existingAlgorithm = (parameters = engine.getSSLParameters()).getEndpointIdentificationAlgorithm())) {
            parameters.setEndpointIdentificationAlgorithm(identityAlg.name());
            engine.setSSLParameters(parameters);
        }
    }

    public static void setup(Socket socket, EndpointIdentificationAlgorithm identityAlg) {
        SSLSocket sslSocket;
        SSLParameters parameters;
        String existingAlgorithm;
        if (null != socket && socket.isConnected() && socket instanceof SSLSocket && null != identityAlg && APIS != identityAlg && StringUtils.isBlank(existingAlgorithm = (parameters = (sslSocket = (SSLSocket)socket).getSSLParameters()).getEndpointIdentificationAlgorithm())) {
            parameters.setEndpointIdentificationAlgorithm(identityAlg.name());
            sslSocket.setSSLParameters(parameters);
        }
    }
}

