/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.consul.ConsulConstants;
import com.networknt.consul.client.ConsulClient;
import com.networknt.utility.ConcurrentHashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulHeartbeatManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsulHeartbeatManager.class);
    private ConsulClient client;
    private String token;
    private ConcurrentHashSet<String> serviceIds = new ConcurrentHashSet();
    private ThreadPoolExecutor jobExecutor;
    private ScheduledExecutorService heartbeatExecutor;
    private boolean lastHeartBeatSwitcherStatus = false;
    private volatile boolean currentHeartBeatSwitcherStatus = false;
    private int switcherCheckTimes = 0;

    public ConsulHeartbeatManager(ConsulClient client, String token) {
        this.client = client;
        this.token = token;
        this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(10000);
        this.jobExecutor = new ThreadPoolExecutor(5, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
    }

    public void start() {
        this.heartbeatExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean switcherStatus = ConsulHeartbeatManager.this.isHeartbeatOpen();
                    if (ConsulHeartbeatManager.this.isSwitcherChange(switcherStatus)) {
                        ConsulHeartbeatManager.this.processHeartbeat(switcherStatus);
                    } else if (switcherStatus) {
                        ConsulHeartbeatManager.this.switcherCheckTimes++;
                        if (ConsulHeartbeatManager.this.switcherCheckTimes >= ConsulConstants.MAX_SWITCHER_CHECK_TIMES) {
                            ConsulHeartbeatManager.this.processHeartbeat(true);
                            ConsulHeartbeatManager.this.switcherCheckTimes = 0;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("consul heartbeat executor err:", e);
                }
            }
        }, ConsulConstants.SWITCHER_CHECK_CIRCLE, ConsulConstants.SWITCHER_CHECK_CIRCLE, TimeUnit.MILLISECONDS);
    }

    private boolean isSwitcherChange(boolean switcherStatus) {
        boolean ret = false;
        if (switcherStatus != this.lastHeartBeatSwitcherStatus) {
            ret = true;
            this.lastHeartBeatSwitcherStatus = switcherStatus;
            logger.info("heartbeat switcher change to " + switcherStatus);
        }
        return ret;
    }

    protected void processHeartbeat(boolean isPass) {
        for (String serviceId : this.serviceIds) {
            try {
                this.jobExecutor.execute(new HeartbeatJob(serviceId, isPass));
            }
            catch (RejectedExecutionException ree) {
                logger.error("execute heartbeat job fail! serviceId:" + serviceId + " is rejected");
            }
        }
    }

    public void close() {
        this.heartbeatExecutor.shutdown();
        this.jobExecutor.shutdown();
        logger.info("Consul heartbeatManager closed.");
    }

    public void addHeartbeatServcieId(String serviceId) {
        this.serviceIds.add(serviceId);
    }

    public void removeHeartbeatServiceId(String serviceId) {
        this.serviceIds.remove(serviceId);
    }

    private boolean isHeartbeatOpen() {
        return this.currentHeartBeatSwitcherStatus;
    }

    public void setHeartbeatOpen(boolean open) {
        this.currentHeartBeatSwitcherStatus = open;
    }

    public void setClient(ConsulClient client) {
        this.client = client;
    }

    class HeartbeatJob
    implements Runnable {
        private String serviceId;
        private boolean isPass;

        public HeartbeatJob(String serviceId, boolean isPass) {
            this.serviceId = serviceId;
            this.isPass = isPass;
        }

        @Override
        public void run() {
            try {
                if (this.isPass) {
                    ConsulHeartbeatManager.this.client.checkPass(this.serviceId, ConsulHeartbeatManager.this.token);
                } else {
                    ConsulHeartbeatManager.this.client.checkFail(this.serviceId, ConsulHeartbeatManager.this.token);
                }
            }
            catch (Exception e) {
                logger.error("consul heartbeat-set check pass error!serviceId:" + this.serviceId, e);
            }
        }
    }
}

