/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulConstants;
import com.networknt.consul.ConsulHeartbeatManager;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.ConsulUtils;
import com.networknt.consul.client.ConsulClient;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLParamType;
import com.networknt.registry.support.command.CommandFailbackRegistry;
import com.networknt.registry.support.command.CommandServiceManager;
import com.networknt.registry.support.command.ServiceListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegistry
extends CommandFailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistry.class);
    private ConsulClient client;
    private ConsulHeartbeatManager heartbeatManager;
    private int lookupInterval;
    private ConcurrentHashMap<String, List<URL>> serviceCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lookupServices = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> serviceListeners = new ConcurrentHashMap();
    private ThreadPoolExecutor notifyExecutor;

    public ConsulRegistry(URL url, ConsulClient client) {
        super(url);
        this.client = client;
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager = new ConsulHeartbeatManager(client, this.getConsulToken());
            this.heartbeatManager.start();
        }
        this.lookupInterval = this.getUrl().getIntParameter(URLParamType.registrySessionTimeout.getName(), ConsulConstants.DEFAULT_LOOKUP_INTERVAL);
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(20000);
        this.notifyExecutor = new ThreadPoolExecutor(10, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
        logger.info("ConsulRegistry init finish.");
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    protected void doRegister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.registerService(service, this.getConsulToken());
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager.addHeartbeatServcieId(service.getId());
        }
    }

    @Override
    protected void doUnregister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.unregisterService(service.getId(), this.getConsulToken());
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager.removeHeartbeatServiceId(service.getId());
        }
    }

    @Override
    protected void doAvailable(URL url) {
        if (url == null) {
            if (this.getConsulConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(true);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support available by urls yet");
        }
    }

    @Override
    protected void doUnavailable(URL url) {
        if (url == null) {
            if (this.getConsulConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(false);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support unavailable by urls yet");
        }
    }

    @Override
    protected void subscribeService(URL url, ServiceListener serviceListener) {
        this.addServiceListener(url, serviceListener);
        this.startListenerThreadIfNewService(url);
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry subscribe. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        manager.addNotifyListener(listener);
        this.subscribeService(urlCopy, manager);
    }

    private void startListenerThreadIfNewService(URL url) {
        Long value;
        String serviceName = url.getPath();
        String protocol = url.getProtocol();
        if (!this.lookupServices.containsKey(serviceName) && (value = this.lookupServices.putIfAbsent(serviceName, 0L)) == null) {
            ServiceLookupThread lookupThread = new ServiceLookupThread(protocol, serviceName);
            lookupThread.setDaemon(true);
            lookupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(URL url, ServiceListener serviceListener) {
        String service = ConsulUtils.getUrlClusterInfo(url);
        ConcurrentHashMap<URL, ServiceListener> map = this.serviceListeners.get(service);
        if (map == null) {
            this.serviceListeners.putIfAbsent(service, new ConcurrentHashMap());
            map = this.serviceListeners.get(service);
        }
        ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            map.put(url, serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeService(URL url, ServiceListener listener) {
        ConcurrentHashMap<URL, ServiceListener> listeners = this.serviceListeners.get(ConsulUtils.getUrlClusterInfo(url));
        if (listeners != null) {
            ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = listeners;
            synchronized (concurrentHashMap) {
                listeners.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<URL> discoverService(URL url) {
        List<URL> urls;
        String serviceName = url.getPath();
        String tag = url.getParameter("environment");
        String protocol = url.getProtocol();
        if (logger.isTraceEnabled()) {
            logger.trace("protocol = " + protocol + " serviceName = " + serviceName + " tag = " + tag);
        }
        if ((urls = this.serviceCache.get(serviceName)) == null || urls.isEmpty()) {
            String string = serviceName.intern();
            synchronized (string) {
                urls = this.serviceCache.get(serviceName);
                if (urls == null || urls.isEmpty()) {
                    ConcurrentHashMap<String, List<URL>> serviceUrls = this.lookupServiceUpdate(protocol, serviceName, false);
                    this.updateServiceCache(serviceName, serviceUrls, false);
                    urls = this.serviceCache.get(serviceName);
                }
            }
        }
        return urls;
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String protocol, String serviceName) {
        return this.lookupServiceUpdate(protocol, serviceName, true);
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String protocol, String serviceName, boolean isBlockQuery) {
        Long lastConsulIndexId = 0L;
        if (isBlockQuery) {
            lastConsulIndexId = this.lookupServices.get(serviceName) == null ? 0L : this.lookupServices.get(serviceName);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("serviceName = " + serviceName + " lastConsulIndexId = " + lastConsulIndexId);
        }
        ConsulResponse<List<ConsulService>> response = this.lookupConsulService(serviceName, lastConsulIndexId);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("response = " + Config.getInstance().getMapper().writeValueAsString(response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConcurrentHashMap<String, List<URL>> serviceUrls = new ConcurrentHashMap<String, List<URL>>();
        if (response != null) {
            List<ConsulService> services = response.getValue();
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("services = " + Config.getInstance().getMapper().writeValueAsString(services));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (services != null && !services.isEmpty() && response.getConsulIndex() > lastConsulIndexId) {
                for (ConsulService service : services) {
                    try {
                        URL url = ConsulUtils.buildUrl(protocol, service);
                        List<URL> urlList = serviceUrls.get(serviceName);
                        if (urlList == null) {
                            urlList = new ArrayList<URL>();
                            serviceUrls.put(serviceName, urlList);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("lookupServiceUpdate url = " + url);
                        }
                        urlList.add(url);
                    }
                    catch (Exception e) {
                        logger.error("convert consul service to url fail! service:" + service, e);
                    }
                }
                this.lookupServices.put(serviceName, response.getConsulIndex());
                return serviceUrls;
            }
            if (response.getConsulIndex() < lastConsulIndexId) {
                logger.info(serviceName + "  lastIndex:" + lastConsulIndexId + "; response consul Index:" + response.getConsulIndex());
                this.lookupServices.put(serviceName, 0L);
            } else {
                logger.info(serviceName + " no need update, lastIndex:" + lastConsulIndexId);
            }
        } else {
            serviceUrls.put(serviceName, new ArrayList());
            logger.info("no response for service: {}, set urls to null", (Object)serviceName);
        }
        return serviceUrls;
    }

    private ConsulResponse<List<ConsulService>> lookupConsulService(String serviceName, Long lastConsulIndexId) {
        ConsulResponse<List<ConsulService>> response = this.client.lookupHealthService(serviceName, null, lastConsulIndexId, this.getConsulToken());
        return response;
    }

    private void updateServiceCache(String serviceName, ConcurrentHashMap<String, List<URL>> serviceUrls, boolean needNotify) {
        if (serviceUrls != null && !serviceUrls.isEmpty()) {
            List<URL> cachedUrls = this.serviceCache.get(serviceName);
            List<URL> newUrls = serviceUrls.get(serviceName);
            try {
                logger.trace("serviceUrls = {}", (Object)Config.getInstance().getMapper().writeValueAsString(serviceUrls));
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean change = true;
            if (ConsulUtils.isSame(newUrls, cachedUrls)) {
                change = false;
            } else {
                this.serviceCache.put(serviceName, newUrls);
            }
            if (change && needNotify) {
                this.notifyExecutor.execute(new NotifyService(serviceName, newUrls));
                logger.info("light service notify-service: " + serviceName);
                StringBuilder sb = new StringBuilder();
                for (URL url : newUrls) {
                    sb.append(url.getUri()).append(";");
                }
                logger.info("consul notify urls:" + sb.toString());
            }
        }
    }

    private ConsulConfig getConsulConfig() {
        return (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    }

    private String getConsulToken() {
        Map<String, Object> secret = Config.getInstance().getJsonMapConfig("secret");
        String token = secret == null ? null : (String)secret.get("consulToken");
        return token;
    }

    private class NotifyService
    implements Runnable {
        private String service;
        private List<URL> urls;

        public NotifyService(String service, List<URL> urls) {
            this.service = service;
            this.urls = urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ConsulRegistry.this.serviceListeners.get(this.service);
            if (listeners != null) {
                ConcurrentHashMap concurrentHashMap = listeners;
                synchronized (concurrentHashMap) {
                    for (Map.Entry entry : listeners.entrySet()) {
                        ServiceListener serviceListener = (ServiceListener)entry.getValue();
                        serviceListener.notifyService((URL)entry.getKey(), ConsulRegistry.this.getUrl(), this.urls);
                    }
                }
            } else {
                logger.debug("need not notify service:" + this.service);
            }
        }
    }

    private class ServiceLookupThread
    extends Thread {
        private String protocol;
        private String serviceName;

        public ServiceLookupThread(String protocol, String serviceName) {
            this.protocol = protocol;
            this.serviceName = serviceName;
        }

        @Override
        public void run() {
            logger.info("start service lookup thread. lookup interval: " + ConsulRegistry.this.lookupInterval + "ms, service: " + this.serviceName);
            while (true) {
                try {
                    while (true) {
                        ServiceLookupThread.sleep(ConsulRegistry.this.lookupInterval);
                        ConcurrentHashMap serviceUrls = ConsulRegistry.this.lookupServiceUpdate(this.protocol, this.serviceName);
                        ConsulRegistry.this.updateServiceCache(this.serviceName, serviceUrls, true);
                    }
                }
                catch (Throwable e) {
                    logger.error("service lookup thread fail!", e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

