/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.client.ConsulClient;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class ConsulClientImpl
implements ConsulClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulClientImpl.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private static final int UNUSUAL_STATUS_CODE = 300;
    private Http2Client client = Http2Client.getInstance();
    private OptionMap optionMap;
    private URI uri;
    private String wait = "600s";

    public ConsulClientImpl() {
        String consulUrl = config.getConsulUrl().toLowerCase();
        this.optionMap = this.isHttp2() ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY;
        logger.debug("url = {}", (Object)consulUrl);
        if (config.getWait() != null && config.getWait().length() > 2) {
            this.wait = config.getWait();
        }
        logger.debug("wait = {}", (Object)this.wait);
        try {
            this.uri = new URI(consulUrl);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI " + consulUrl, e);
            throw new RuntimeException("Invalid URI " + consulUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPass(String serviceId, String token) {
        logger.trace("checkPass serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/pass/check-" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkPass on Consul: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckPass request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFail(String serviceId, String token) {
        logger.trace("checkFail serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/fail/check-" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkFail on Consul: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckFail request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    @Override
    public void registerService(ConsulService service, String token) {
        String json = service.toString();
        String path = "/v1/agent/service/register";
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, json);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to register on Consul: " + statusCode);
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            try {
                logger.error("Failed to register on Consul, Exception:", e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.client.returnConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(String serviceId, String token) {
        String path = "/v1/agent/service/deregister/" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to unregister on Consul, body = {}", (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("Failed to unregister on Consul, Exception:", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsulResponse<List<ConsulService>> lookupHealthService(String serviceName, String tag, long lastConsulIndex, String token) {
        ConsulResponse<ArrayList<ConsulService>> newResponse = null;
        if (StringUtils.isBlank(serviceName)) {
            return null;
        }
        ClientConnection connection = null;
        String path = "/v1/health/service/" + serviceName + "?passing&wait=" + this.wait + "&index=" + lastConsulIndex;
        if (tag != null) {
            path = path + "&tag=" + tag;
        }
        logger.trace("path = {}", (Object)path);
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.GET, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to unregister on Consul: " + statusCode);
            }
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            List<Map<String, Object>> services = Config.getInstance().getMapper().readValue(body, new TypeReference<List<Map<String, Object>>>(){});
            ArrayList<ConsulService> ConsulServcies = new ArrayList<ConsulService>(services.size());
            for (Map<String, Object> service : services) {
                ConsulService newService = this.convertToConsulService((Map)service.get("Service"));
                ConsulServcies.add(newService);
            }
            if (!ConsulServcies.isEmpty()) {
                newResponse = new ConsulResponse<ArrayList<ConsulService>>();
                newResponse.setValue(ConsulServcies);
                newResponse.setConsulIndex(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Index")));
                newResponse.setConsulLastContact(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Lastcontact")));
                newResponse.setConsulKnownLeader(Boolean.parseBoolean(reference.get().getResponseHeaders().getFirst("X-Consul-Knownleader")));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
        return newResponse;
    }

    private ConsulService convertToConsulService(Map<String, Object> serviceMap) {
        ConsulService service = new ConsulService();
        service.setAddress((String)serviceMap.get("Address"));
        service.setId((String)serviceMap.get("ID"));
        service.setName((String)serviceMap.get("Service"));
        service.setPort((Integer)serviceMap.get("Port"));
        service.setTags((List)serviceMap.get("Tags"));
        return service;
    }

    AtomicReference<ClientResponse> send(ClientConnection connection, HttpString method, String path, String token, String json) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        ClientRequest request = new ClientRequest().setMethod(method).setPath(path);
        request.getRequestHeaders().put(Headers.HOST, "localhost");
        if (token != null) {
            request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
        }
        logger.trace("The request sent to consul: {} = request header: {}, request body is empty", (Object)this.uri.toString(), (Object)request.toString());
        if (StringUtils.isBlank(json)) {
            connection.sendRequest(request, this.client.createClientCallback(reference, latch));
        } else {
            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
            connection.sendRequest(request, this.client.createClientCallback(reference, latch, json));
        }
        latch.await();
        logger.trace("The response got from consul: {} = {}", (Object)this.uri.toString(), (Object)reference.get().toString());
        return reference;
    }

    private boolean isHttp2() {
        return config.isEnableHttp2() || config.getConsulUrl().toLowerCase().startsWith("https");
    }
}

