/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpConfig {
    private boolean enabled = false;
    private boolean mask = false;
    private String logLevel = "INFO";
    private int indentSize = 4;
    private boolean useJson = false;
    private Map<String, Object> request;
    private Map<String, Object> response;
    private static Boolean DEFAULT = false;
    private boolean requestUrlEnabled;
    private boolean requestHeaderEnabled;
    private List<String> requestFilteredHeaders;
    private boolean requestCookieEnabled;
    private List<String> requestFilteredCookies;
    private boolean requestQueryParametersEnabled;
    private List<String> requestFilteredQueryParameters;
    private boolean requestBodyEnabled;
    private boolean responseHeaderEnabled;
    private List<String> responseFilteredHeaders;
    private boolean responseCookieEnabled;
    private List<String> responseFilteredCookies;
    private boolean responseStatusCodeEnabled;
    private boolean responseBodyEnabled;

    public void setResponse(Map<String, Object> response) {
        this.response = response == null ? new HashMap() : response;
        this.loadResponseConfig(this.response);
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request == null ? new HashMap() : request;
        this.loadRequestConfig(this.request);
    }

    private void loadRequestConfig(Map<String, Object> request) {
        this.requestBodyEnabled = this.loadEnableConfig(request, "body");
        this.requestCookieEnabled = this.loadEnableConfig(request, "cookies");
        this.requestHeaderEnabled = this.loadEnableConfig(request, "headers");
        this.requestQueryParametersEnabled = this.loadEnableConfig(request, "queryParameters");
        this.requestUrlEnabled = this.loadEnableConfig(request, "url");
        this.requestFilteredCookies = this.loadFilterConfig(request, "filteredCookies");
        this.requestFilteredHeaders = this.loadFilterConfig(request, "filteredHeaders");
        this.requestFilteredQueryParameters = this.loadFilterConfig(request, "filteredQueryParameters");
    }

    private void loadResponseConfig(Map<String, Object> response) {
        this.responseBodyEnabled = this.loadEnableConfig(response, "body");
        this.responseCookieEnabled = this.loadEnableConfig(response, "cookies");
        this.responseHeaderEnabled = this.loadEnableConfig(response, "headers");
        this.responseStatusCodeEnabled = this.loadEnableConfig(response, "statusCode");
        this.responseFilteredCookies = this.loadFilterConfig(response, "filteredCookies");
        this.responseFilteredHeaders = this.loadFilterConfig(response, "headers");
    }

    private boolean loadEnableConfig(Map<String, Object> config, String optionName) {
        return config.get(optionName) instanceof Boolean ? (Boolean)config.get(optionName) : DEFAULT;
    }

    private List<String> loadFilterConfig(Map<String, Object> config, String filterOptionName) {
        return config.get(filterOptionName) instanceof List ? (List)config.get(filterOptionName) : new ArrayList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRequestEnabled() {
        return this.isEnabled() && !this.request.isEmpty();
    }

    public boolean isResponseEnabled() {
        return this.isEnabled() && !this.response.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isMaskEnabled() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public boolean isUseJson() {
        return this.useJson;
    }

    public void setUseJson(boolean useJson) {
        this.useJson = useJson;
    }

    public Map<String, Object> getRequest() {
        return this.request;
    }

    public Map<String, Object> getResponse() {
        return this.response;
    }

    public boolean isRequestUrlEnabled() {
        return this.requestUrlEnabled;
    }

    public boolean isRequestHeaderEnabled() {
        return this.requestHeaderEnabled;
    }

    public List<String> getRequestFilteredHeaders() {
        return this.requestFilteredHeaders;
    }

    public boolean isRequestCookieEnabled() {
        return this.requestCookieEnabled;
    }

    public List<String> getRequestFilteredCookies() {
        return this.requestFilteredCookies;
    }

    public boolean isRequestQueryParametersEnabled() {
        return this.requestQueryParametersEnabled;
    }

    public List<String> getRequestFilteredQueryParameters() {
        return this.requestFilteredQueryParameters;
    }

    public boolean isRequestBodyEnabled() {
        return this.requestBodyEnabled;
    }

    public boolean isResponseHeaderEnabled() {
        return this.responseHeaderEnabled;
    }

    public List<String> getResponseFilteredHeaders() {
        return this.responseFilteredHeaders;
    }

    public boolean isResponseCookieEnabled() {
        return this.responseCookieEnabled;
    }

    public List<String> getResponseFilteredCookies() {
        return this.responseFilteredCookies;
    }

    public boolean isResponseStatusCodeEnabled() {
        return this.responseStatusCodeEnabled;
    }

    public boolean isResponseBodyEnabled() {
        return this.responseBodyEnabled;
    }
}

