/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.DumpHandler;
import com.networknt.utility.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DumpHelper {
    private static Logger logger = LoggerFactory.getLogger(DumpHandler.class);

    DumpHelper() {
    }

    static void logResult(Map<String, Object> result, DumpConfig config) {
        Consumer<String> loggerFunc = DumpHelper.getLoggerFuncBasedOnLevel(config.getLogLevel());
        if (config.isUseJson()) {
            DumpHelper.logResultUsingJson(result, loggerFunc);
        } else {
            int startLevel = -1;
            StringBuilder sb = new StringBuilder("Http request/response information:");
            DumpHelper._logResult(result, startLevel, config.getIndentSize(), sb);
            loggerFunc.accept(sb.toString());
        }
    }

    private static <T> void _logResult(T result, int level, int indentSize, StringBuilder info) {
        if (result instanceof Map) {
            int finalLevel = ++level;
            ((Map)result).forEach((k, v) -> {
                info.append("\n");
                info.append(DumpHelper.getTabBasedOnLevel(finalLevel, indentSize)).append(k.toString()).append(":");
                DumpHelper._logResult(v, finalLevel, indentSize, info);
            });
        } else if (result instanceof List) {
            int finalLevel = level;
            ((List)result).forEach(element -> DumpHelper._logResult(element, finalLevel, indentSize, info));
        } else if (result instanceof String) {
            info.append(" ").append(result);
        } else if (result != null) {
            try {
                logger.warn(DumpHelper.getTabBasedOnLevel(level, indentSize) + "{}", (Object)result);
            }
            catch (Exception e) {
                logger.error("Cannot handle this type: {}", (Object)result.getClass().getTypeName());
            }
        }
    }

    private static void logResultUsingJson(Map<String, Object> result, Consumer<String> loggerFunc) {
        ObjectMapper mapper = new ObjectMapper();
        String resultJson = "";
        try {
            resultJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            logger.error(e.toString());
        }
        if (StringUtils.isNotBlank(resultJson)) {
            loggerFunc.accept("Dump Info:\n" + resultJson);
        }
    }

    private static String getTabBasedOnLevel(int level, int indentSize) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            for (int j = 0; j < indentSize; ++j) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    private static Consumer<String> getLoggerFuncBasedOnLevel(String level) {
        switch (level.toUpperCase()) {
            case "ERROR": {
                return logger::error;
            }
            case "INFO": {
                return logger::info;
            }
            case "DEBUG": {
                return logger::debug;
            }
            case "WARN": {
                return logger::warn;
            }
        }
        return logger::info;
    }
}

