/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.Builder;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ScalarOverlay;
import com.networknt.jsonoverlay.SerializationOptions;

public final class IntegerOverlay
extends ScalarOverlay<Integer> {
    public static OverlayFactory<Integer> factory = new OverlayFactory<Integer>(){

        @Override
        protected Class<IntegerOverlay> getOverlayClass() {
            return IntegerOverlay.class;
        }

        public IntegerOverlay _create(Integer value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new IntegerOverlay(value, parent, refMgr);
        }

        public IntegerOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new IntegerOverlay(json, parent, refMgr);
        }
    };

    private IntegerOverlay(Integer value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    private IntegerOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    @Override
    protected Integer _fromJson(JsonNode json) {
        return json.isInt() ? Integer.valueOf(json.intValue()) : null;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? IntegerOverlay._jsonScalar((Integer)this.value) : IntegerOverlay._jsonMissing();
    }

    @Override
    protected OverlayFactory<Integer> _getFactory() {
        return factory;
    }

    public static Builder<Integer> builder(JsonOverlay<?> modelMember) {
        return new Builder<Integer>(factory, modelMember);
    }

    public static JsonOverlay<Integer> create(JsonOverlay<?> modelMember) {
        return IntegerOverlay.builder(modelMember).build();
    }

    public static JsonOverlay<Integer> create(int value, JsonOverlay<?> modelMember) {
        JsonOverlay<Integer> result = IntegerOverlay.create(modelMember);
        result._set(value);
        return result;
    }
}

