/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.JsonLoader;
import com.networknt.jsonoverlay.PositionInfo;
import com.networknt.jsonoverlay.Reference;
import com.networknt.jsonoverlay.ReferenceRegistry;
import com.networknt.jsonoverlay.ResolutionException;
import com.networknt.url.URLNormalizer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ReferenceManager {
    private ReferenceRegistry registry;
    private URL docUrl;
    private JsonNode doc = null;
    private Map<JsonPointer, Optional<PositionInfo>> positions = new HashMap<JsonPointer, Optional<PositionInfo>>();

    public ReferenceManager() {
        this((URL)null, (JsonLoader)null);
    }

    public ReferenceManager(URL rootUrl) {
        this(rootUrl, (JsonLoader)null);
    }

    public ReferenceManager(URL rootUrl, JsonLoader loader) {
        this.registry = new ReferenceRegistry(loader);
        URL uRL = this.docUrl = rootUrl != null ? ReferenceManager.normalize(rootUrl, true) : null;
        if (this.docUrl != null) {
            this.registry.registerManager(this.docUrl, this);
        }
    }

    public ReferenceManager(URL rootUrl, JsonNode preloadedDoc, JsonLoader loader) {
        this(rootUrl, loader);
        this.doc = preloadedDoc;
    }

    private ReferenceManager(URL baseUrl, ReferenceRegistry registry) {
        this.docUrl = baseUrl;
        this.registry = registry;
    }

    public Reference getDocReference() {
        return this.getReference(this.docUrl.toString());
    }

    public ReferenceManager getManagerFor(URL url) {
        URL normalized = ReferenceManager.normalize(url, true);
        ReferenceManager manager = this.registry.getManager(normalized);
        if (manager == null) {
            manager = new ReferenceManager(normalized, this.registry);
            this.registry.registerManager(normalized, manager);
        }
        return manager;
    }

    public Reference getReference(JsonNode refNode) {
        String refString = refNode.get("$ref").asText();
        return this.getReference(refString);
    }

    public Reference getReference(String refString) {
        try {
            URL url = new URL(this.docUrl, refString);
            String fragment = url.getRef();
            ReferenceManager manager = this.getManagerFor(url);
            return new Reference(refString, fragment, ReferenceManager.normalize(url, false).toString(), manager);
        }
        catch (MalformedURLException e) {
            return new Reference(refString, new ResolutionException(null, (Throwable)e), null);
        }
    }

    public Optional<PositionInfo> getPositionInfo(JsonPointer pointer) {
        if (!this.positions.containsKey(pointer)) {
            this.positions.put(pointer, this.registry.getPositionInfo(this.docUrl.toString(), pointer));
        }
        return this.positions.get(pointer);
    }

    public JsonNode loadDoc() throws IOException {
        if (this.doc == null) {
            this.doc = this.registry.loadDoc(this.docUrl);
        }
        return this.doc;
    }

    public ReferenceRegistry getRegistry() {
        return this.registry;
    }

    private static URL normalize(URL url, boolean noFrag) {
        if (url != null) {
            URLNormalizer normalizer = new URLNormalizer(url.toString()).lowerCaseSchemeHost().upperCaseEscapeSequence().decodeUnreservedCharacters().removeDefaultPort().encodeNonURICharacters().removeDotSegments();
            if (noFrag) {
                normalizer = normalizer.removeFragment();
            }
            return normalizer.toURL();
        }
        return null;
    }
}

