/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.metrics.JVMMetricsUtil;
import io.dropwizard.metrics.Counter;
import io.dropwizard.metrics.Gauge;
import io.dropwizard.metrics.Histogram;
import io.dropwizard.metrics.Meter;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.ScheduledReporter;
import io.dropwizard.metrics.Timer;
import io.dropwizard.metrics.influxdb.InfluxDbSender;
import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMMetricsInfluxDbReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(JVMMetricsInfluxDbReporter.class);
    private final InfluxDbSender influxDb;
    private final MetricRegistry registry;
    private final Map<String, String> tags;

    public JVMMetricsInfluxDbReporter(MetricRegistry registry, InfluxDbSender influxDb, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Map<String, String> tags) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.influxDb = influxDb;
        this.registry = registry;
        this.tags = tags;
    }

    @Override
    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        long now = System.currentTimeMillis();
        JVMMetricsUtil.trackAllJVMMetrics(this.registry, this.tags);
        if (logger.isDebugEnabled()) {
            logger.debug("InfluxDbReporter report is called with counter size " + counters.size());
        }
        try {
            this.influxDb.flush();
            for (Map.Entry<MetricName, Gauge> entry : this.registry.getGauges().entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), now);
            }
            if (this.influxDb.hasSeriesData()) {
                this.influxDb.writeData();
            }
        }
        catch (Exception e) {
            logger.error("Unable to report to InfluxDB. Discarding data.", e);
        }
    }

    private void reportGauge(MetricName name, Gauge<?> gauge, long now) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            HashMap<String, String> apiTags = new HashMap<String, String>(name.getTags());
            String apiName = (String)apiTags.remove("apiName");
            HashMap<String, String> clientTags = new HashMap<String, String>(name.getTags());
            String clientId = (String)clientTags.remove("clientId");
            this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name.getKey(), apiTags, now, value));
            if (clientId != null) {
                this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name.getKey(), clientTags, now, value));
            }
        }
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.4f", v);
    }
}

