/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.openapi.parameter.CookieParameterDeserializer;
import com.networknt.openapi.parameter.HeaderParameterDeserializer;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.openapi.parameter.PathParameterDeserializer;
import com.networknt.openapi.parameter.QueryParameterDeserializer;
import com.networknt.utility.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum ParameterType {
    PATH(new PathParameterDeserializer()),
    QUERY(new QueryParameterDeserializer()),
    HEADER(new HeaderParameterDeserializer()),
    COOKIE(new CookieParameterDeserializer());

    private static Map<String, ParameterType> lookup;
    private final ParameterDeserializer deserializer;

    private ParameterType(ParameterDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public static ParameterType of(String typeStr) {
        return lookup.get(StringUtils.trimToEmpty(typeStr).toUpperCase());
    }

    public static boolean is(String typeStr, ParameterType type) {
        return type == ParameterType.of(typeStr);
    }

    public ParameterDeserializer getDeserializer() {
        return this.deserializer;
    }

    static {
        lookup = new HashMap<String, ParameterType>();
        for (ParameterType type : ParameterType.values()) {
            lookup.put(type.name(), type);
        }
    }
}

