/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger logger = LoggerFactory.getLogger(HandlerUtils.class);

    public static String findServiceId(String searchKey, Map<String, String> mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug("findServiceId for " + searchKey);
        }
        String serviceId = null;
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String prefix = entry.getKey();
            if (!searchKey.startsWith(prefix) || searchKey.length() != prefix.length() && searchKey.charAt(prefix.length()) != '/') continue;
            serviceId = entry.getValue();
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("serviceId = " + serviceId);
        }
        return serviceId;
    }

    public static String normalisePath(String requestPath) {
        if (!requestPath.startsWith("/")) {
            return "/" + requestPath;
        }
        return requestPath;
    }
}

