/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.TokenHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathServiceHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "pathService";
    public static final String ENABLED = "enabled";
    public static final String MAPPING = "mapping";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("pathService");
    public static Map<String, String> mapping = (Map)config.get("mapping");
    static Logger logger = LoggerFactory.getLogger(PathServiceHandler.class);
    private volatile HttpHandler next;
    static final String AUDIT_INFO_NOT_FOUND = "ERR10041";

    public PathServiceHandler() {
        logger.info("PathServiceHandler is constructed");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null) {
            String endpoint = (String)auditInfo.get("endpoint");
            if (logger.isDebugEnabled()) {
                logger.debug("endpoint = " + endpoint);
            }
            if (endpoint != null) {
                String serviceId = mapping.get(endpoint);
                exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceId);
            }
        } else {
            this.setExchangeStatus(exchange, AUDIT_INFO_NOT_FOUND, new Object[0]);
            return;
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(TokenHandler.class.getName(), config, null);
    }
}

