/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.HandlerUtils;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDictHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDictHandler.class);
    protected static final String INTERNAL_KEY_FORMAT = "%s %s";
    public static final String CONFIG_NAME = "serviceDict";
    public static final String ENABLED = "enabled";
    public static final String MAPPING = "mapping";
    public static final String DELIMITOR = "@";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("serviceDict");
    protected static Map<String, String> rawMappings = (Map)config.get("mapping");
    public static Map<String, String> mappings = new HashMap<String, String>();
    private volatile HttpHandler next;
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";

    public ServiceDictHandler() {
        logger.info("ServiceDictHandler is constructed");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId;
        HeaderValues serviceIdHeader = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID);
        String string = serviceId = serviceIdHeader != null ? serviceIdHeader.peekFirst() : null;
        if (serviceId == null) {
            String requestPath = exchange.getRequestURI();
            String httpMethod = exchange.getRequestMethod().toString().toLowerCase();
            serviceId = HandlerUtils.findServiceId(ServiceDictHandler.toInternalKey(httpMethod, requestPath), mappings);
            if (serviceId == null) {
                this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, requestPath);
                return;
            }
            exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceId);
        }
        Handler.next(exchange, this.next);
    }

    private static String toInternalKey(String key) {
        String[] tokens = StringUtils.trimToEmpty(key).split(DELIMITOR);
        if (tokens.length == 2) {
            return ServiceDictHandler.toInternalKey(tokens[1], tokens[0]);
        }
        logger.warn("Invalid key {}", (Object)key);
        return key;
    }

    protected static String toInternalKey(String method, String path) {
        return String.format(INTERNAL_KEY_FORMAT, method, HandlerUtils.normalisePath(path));
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ServiceDictHandler.class.getName(), config, null);
    }

    static {
        for (Map.Entry<String, String> entry : rawMappings.entrySet()) {
            mappings.put(ServiceDictHandler.toInternalKey(entry.getKey()), entry.getValue());
        }
        mappings = Collections.unmodifiableMap(mappings);
    }
}

