/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private final String formatName;
    private final String DATE = "date";
    private final String DATETIME = "date-time";
    private static final Pattern RFC3339_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})([Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?)?([Zz]|([+-])(\\d{2}):?(\\d{2}))?");

    public DateTimeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, String formatName) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DATETIME, validationContext);
        this.formatName = formatName;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (!this.isLegalDateTime(node.textValue())) {
            errors.add(this.buildValidationMessage(at, node.textValue(), this.formatName));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isLegalDateTime(String string) {
        Matcher matcher = RFC3339_PATTERN.matcher(string);
        StringBuilder pattern = new StringBuilder();
        StringBuilder dateTime = new StringBuilder();
        if (!matcher.matches()) {
            logger.error("Failed to apply RFC3339 pattern on " + string);
            return false;
        }
        String year = matcher.group(1);
        String month = matcher.group(2);
        String day = matcher.group(3);
        dateTime.append(year).append('-').append(month).append('-').append(day);
        pattern.append("yyyy-MM-dd");
        boolean isTimeGiven = matcher.group(4) != null;
        String timeZoneShiftRegexGroup = matcher.group(9);
        boolean isTimeZoneShiftGiven = timeZoneShiftRegexGroup != null;
        String hour = null;
        String minute = null;
        String second = null;
        String milliseconds = null;
        String timeShiftHour = null;
        String timeShiftMinute = null;
        if (!isTimeGiven && "date-time".equals(this.formatName) || isTimeGiven && "date".equals(this.formatName)) {
            logger.error("The supplied date/time format type does not match the specification, expected: " + this.formatName);
            return false;
        }
        if (!isTimeGiven && isTimeZoneShiftGiven) {
            logger.error("Invalid date/time format, cannot specify time zone shift without specifying time: " + string);
            return false;
        }
        if (isTimeGiven) {
            hour = matcher.group(5);
            minute = matcher.group(6);
            second = matcher.group(7);
            dateTime.append('T').append(hour).append(':').append(minute).append(':').append(second);
            pattern.append("'T'HH:mm:ss");
            if (matcher.group(8) != null) {
                milliseconds = matcher.group(8);
                if (milliseconds.length() > 4) {
                    milliseconds = milliseconds.substring(0, 4);
                } else {
                    while (milliseconds.length() < 4) {
                        milliseconds = milliseconds + "0";
                    }
                }
                dateTime.append(milliseconds);
                pattern.append(".SSS");
            }
        }
        if (isTimeGiven && isTimeZoneShiftGiven) {
            if (Character.toUpperCase(timeZoneShiftRegexGroup.charAt(0)) == 'Z') {
                dateTime.append('Z');
                pattern.append("'Z'");
            } else {
                timeShiftHour = matcher.group(11);
                timeShiftMinute = matcher.group(12);
                dateTime.append(matcher.group(10).charAt(0)).append(timeShiftHour).append(':').append(timeShiftMinute);
                pattern.append("XXX");
            }
        }
        return this.validateDateTime(dateTime.toString(), pattern.toString());
    }

    private boolean validateDateTime(String dateTime, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf.parse(dateTime, new ParsePosition(0)) != null;
    }
}

