/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSchema
extends BaseJsonValidator {
    private static final Pattern intPattern = Pattern.compile("^[0-9]+$");
    protected final Map<String, JsonValidator> validators;
    private final ValidationContext validationContext;
    private final URI currentUri;
    private JsonValidator requiredValidator = null;

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode) {
        this(validationContext, "#", baseUri, schemaNode, null);
    }

    public JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent) {
        this(validationContext, schemaPath, currentUri, schemaNode, parent, false);
    }

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode, boolean suppressSubSchemaRetrieval) {
        this(validationContext, "#", baseUri, schemaNode, null, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaPath, schemaNode, parent, null, suppressSubSchemaRetrieval, validationContext.getConfig() != null && validationContext.getConfig().isFailFast());
        this.validationContext = validationContext;
        this.config = validationContext.getConfig();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
        this.validators = Collections.unmodifiableMap(this.read(schemaNode));
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        JsonNode idNode = schemaNode.get("id");
        if (idNode == null) {
            return currentUri;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, idNode.asText());
        }
        catch (IllegalArgumentException e) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.ID.getValue(), (ErrorMessageType)ValidatorTypeCode.ID, idNode.asText(), currentUri.toString()));
        }
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        if (ref.startsWith("#/")) {
            String[] keys;
            for (String key : keys = ref.substring(2).split("/")) {
                JsonSchema subSchema;
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Matcher matcher = intPattern.matcher(key);
                node = matcher.matches() ? node.get(Integer.parseInt(key)) : node.get(key);
                if (node == null && (subSchema = schema.fetchSubSchemaNode(this.validationContext)) != null) {
                    node = subSchema.getRefSchemaNode(ref);
                }
                if (node == null) break;
            }
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private Map<String, JsonValidator> read(JsonNode schemaNode) {
        HashMap<String, JsonValidator> validators = new HashMap<String, JsonValidator>();
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "true", schemaNode, this);
                validators.put(this.getSchemaPath() + "/true", validator);
            } else {
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "false", schemaNode, this);
                validators.put(this.getSchemaPath() + "/false", validator);
            }
        } else {
            Iterator<String> pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                JsonNode nodeToUse;
                String pname = pnames.next();
                JsonNode jsonNode = nodeToUse = pname.equals("if") ? schemaNode : schemaNode.get(pname);
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), pname, nodeToUse, this);
                if (validator == null) continue;
                validators.put(this.getSchemaPath() + "/" + pname, validator);
                if (!pname.equals("required")) continue;
                this.requiredValidator = validator;
            }
        }
        return validators;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode jsonNode, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonValidator v : this.validators.values()) {
            errors.addAll(v.validate(jsonNode, rootNode, at));
        }
        return errors;
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }
}

