/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.influxdb;

import com.networknt.client.Http2Client;
import com.networknt.exception.ClientException;
import com.networknt.mask.Mask;
import io.dropwizard.metrics.influxdb.InfluxDbReporter;
import io.dropwizard.metrics.influxdb.InfluxDbSender;
import io.dropwizard.metrics.influxdb.TimeUtils;
import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import io.dropwizard.metrics.influxdb.data.InfluxDbWriteObject;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class InfluxDbHttpSender
implements InfluxDbSender {
    private static final Logger logger = LoggerFactory.getLogger(InfluxDbReporter.class);
    private final Http2Client client = Http2Client.getInstance();
    private final URL url;
    private final String path;
    private final InfluxDbWriteObject influxDbWriteObject;

    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String username, String password) throws Exception {
        this(protocol, hostname, port, database, username, password, TimeUnit.MILLISECONDS);
    }

    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this.url = new URL(protocol, hostname, port, "");
        String queryDb = String.format("db=%s", URLEncoder.encode(database, "UTF-8"));
        String queryCredential = String.format("u=%s&p=%s", URLEncoder.encode(username, "UTF8"), URLEncoder.encode(password, "UTF8"));
        String queryPrecision = String.format("precision=%s", TimeUtils.toTimePrecision(timePrecision));
        this.path = "/write?" + queryDb + "&" + queryCredential + "&" + queryPrecision;
        if (logger.isInfoEnabled()) {
            logger.info("InfluxDbHttpSender is created with path = " + Mask.maskString(this.path, "uri") + " and host = " + this.url);
        }
        this.influxDbWriteObject = new InfluxDbWriteObject(timePrecision);
    }

    @Override
    public void flush() {
        this.influxDbWriteObject.setPoints(new HashSet<InfluxDbPoint>());
    }

    @Override
    public boolean hasSeriesData() {
        return this.influxDbWriteObject.getPoints() != null && !this.influxDbWriteObject.getPoints().isEmpty();
    }

    @Override
    public void appendPoints(InfluxDbPoint point) {
        if (point != null) {
            this.influxDbWriteObject.getPoints().add(point);
        }
    }

    @Override
    public int writeData() throws Exception {
        ClientConnection connection;
        final String body = this.influxDbWriteObject.getBody();
        final AtomicReference reference = new AtomicReference();
        final Http2Client client = Http2Client.getInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(this.url.toURI(), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.EMPTY).get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(InfluxDbHttpSender.this.path);
                    request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                    request.getRequestHeaders().put(Headers.HOST, "localhost");
                    request.getRequestHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                    connection.sendRequest(request, client.createClientCallback(reference, latch, body));
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("IOException: ", e);
            throw new ClientException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        int statusCode = ((ClientResponse)reference.get()).getResponseCode();
        if (statusCode >= 200 && statusCode < 300) {
            return statusCode;
        }
        logger.error("Server returned HTTP response code: " + statusCode + "for path: " + this.path + " and host: " + this.url + " with content :'" + ((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY) + "'");
        throw new ClientException("Server returned HTTP response code: " + statusCode + "for path: " + this.path + " and host: " + this.url + " with content :'" + ((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY) + "'");
    }

    @Override
    public void setTags(Map<String, String> tags) {
        if (tags != null) {
            this.influxDbWriteObject.setTags(tags);
        }
    }
}

