/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.networknt.auth.PortalClient;
import com.networknt.auth.StatelessAuthConfig;
import com.networknt.auth.StatelessAuthHandler;
import com.networknt.client.oauth.ClientAuthenticatedUserRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.monad.Result;
import com.networknt.status.Status;
import com.networknt.utility.Util;
import com.restfb.DefaultFacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.types.User;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookAuthHandler
extends StatelessAuthHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(FacebookAuthHandler.class);
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String AUTHORIZATION_CODE_MISSING = "ERR10035";
    private static final String EMAIL_REGISTERED = "ERR11350";
    public static StatelessAuthConfig config = (StatelessAuthConfig)Config.getInstance().getJsonObjectConfig("statelessAuth", StatelessAuthConfig.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRelativePath().equals(config.getFacebookPath())) {
            String accessToken;
            Deque<String> deque = exchange.getQueryParameters().get(ACCESS_TOKEN);
            String string = accessToken = deque == null ? null : deque.getFirst();
            if (logger.isDebugEnabled()) {
                logger.debug("access_token = " + accessToken);
            }
            if (accessToken == null || accessToken.trim().length() == 0) {
                this.setExchangeStatus(exchange, AUTHORIZATION_CODE_MISSING, new Object[0]);
                return;
            }
            DefaultFacebookClient fbClient = new DefaultFacebookClient(accessToken, Version.VERSION_3_1);
            User me = fbClient.fetchObject("me", User.class, Parameter.with("fields", "id,name,email,first_name,last_name,verified"));
            if (me != null) {
                Object id;
                Map<Object, Object> map;
                String email = me.getEmail();
                String firstName = me.getFirstName();
                String lastName = me.getLastName();
                String name = me.getName();
                String userId = name.replaceAll("\\s+", "") + "@fb";
                Result<String> resultUser = PortalClient.getUserByEmail(email, config.getBootstrapToken());
                if (resultUser.isSuccess()) {
                    map = JsonMapper.string2Map(resultUser.getResult());
                    id = (String)map.get("userId");
                    if (!userId.equals(id)) {
                        this.setExchangeStatus(exchange, EMAIL_REGISTERED, email, id);
                        return;
                    }
                } else {
                    map = new HashMap();
                    map.put("host", "lightapi.net");
                    map.put("email", email);
                    map.put("userId", userId);
                    map.put("language", "en");
                    map.put("firstName", firstName);
                    map.put("lastName", lastName);
                    id = PortalClient.createSocialUser(map, config.getBootstrapToken());
                }
                String csrf = Util.getUUID();
                ClientAuthenticatedUserRequest request = new ClientAuthenticatedUserRequest("social", email, "user");
                request.setCsrf(csrf);
                Result<TokenResponse> result = OauthHelper.getTokenResult(request);
                if (result.isFailure()) {
                    Status status = result.getError();
                    exchange.setStatusCode(status.getStatusCode());
                    exchange.getResponseSender().send(status.toString());
                    logger.error(status.toString());
                    return;
                }
                List<String> scopes = this.setCookies(exchange, result.getResult(), csrf);
                if (config.getRedirectUri() != null && config.getRedirectUri().length() > 0) {
                    exchange.setStatusCode(200);
                    HashMap<String, Object> rs = new HashMap<String, Object>();
                    rs.put("scopes", scopes);
                    rs.put("redirectUri", FacebookAuthHandler.config.redirectUri);
                    rs.put("denyUri", FacebookAuthHandler.config.denyUri != null ? FacebookAuthHandler.config.denyUri : FacebookAuthHandler.config.redirectUri);
                    exchange.getResponseSender().send(JsonMapper.toJson(rs));
                } else {
                    exchange.setStatusCode(200);
                    exchange.endExchange();
                }
            } else {
                this.setExchangeStatus(exchange, AUTHORIZATION_CODE_MISSING, new Object[0]);
                return;
            }
        }
    }
}

