/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.networknt.auth.StatelessAuthConfig;
import com.networknt.auth.StatelessAuthHandler;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubAuthHandler
extends StatelessAuthHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(GithubAuthHandler.class);
    private static final String CODE = "code";
    private static final String AUTHORIZATION_CODE_MISSING = "ERR10035";
    public static StatelessAuthConfig config = (StatelessAuthConfig)Config.getInstance().getJsonObjectConfig("statelessAuth", StatelessAuthConfig.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRelativePath().equals(config.getGithubPath())) {
            String code;
            Deque<String> deque = exchange.getQueryParameters().get(CODE);
            String string = code = deque == null ? null : deque.getFirst();
            if (logger.isDebugEnabled()) {
                logger.debug("code = " + code);
            }
            if (code == null || code.trim().length() == 0) {
                this.setExchangeStatus(exchange, AUTHORIZATION_CODE_MISSING, new Object[0]);
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("client_id", config.getGithubClientId());
            map.put("client_secret", config.getGithubClientSecret());
            map.put(CODE, code);
            map.put("redirect_uri", "https://localhost:3000/");
        }
    }
}

