/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.networknt.auth.PortalClient;
import com.networknt.auth.StatelessAuthConfig;
import com.networknt.auth.StatelessAuthHandler;
import com.networknt.client.oauth.ClientAuthenticatedUserRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.monad.Result;
import com.networknt.status.Status;
import com.networknt.utility.Util;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthHandler
extends StatelessAuthHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(GoogleAuthHandler.class);
    private static final String CODE = "code";
    private static final String AUTHORIZATION_CODE_MISSING = "ERR10035";
    private static final String EMAIL_REGISTERED = "ERR11350";
    public static StatelessAuthConfig config = (StatelessAuthConfig)Config.getInstance().getJsonObjectConfig("statelessAuth", StatelessAuthConfig.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("exchange path = " + exchange.getRelativePath() + " config path = " + config.getGooglePath());
        }
        if (exchange.getRelativePath().equals(config.getGooglePath())) {
            Object id;
            Map<Object, Object> map;
            String code;
            Deque<String> deque = exchange.getQueryParameters().get(CODE);
            String string = code = deque == null ? null : deque.getFirst();
            if (logger.isDebugEnabled()) {
                logger.debug("auth code = " + code);
            }
            if (code == null || code.trim().length() == 0) {
                this.setExchangeStatus(exchange, AUTHORIZATION_CODE_MISSING, new Object[0]);
                return;
            }
            GoogleTokenResponse tokenResponse = new GoogleAuthorizationCodeTokenRequest(new NetHttpTransport(), JacksonFactory.getDefaultInstance(), "https://oauth2.googleapis.com/token", config.getGoogleClientId(), config.getGoogleClientSecret(), code, config.getGoogleRedirectUri()).execute();
            GoogleIdToken idToken = tokenResponse.parseIdToken();
            GoogleIdToken.Payload payload = idToken.getPayload();
            String email = payload.getEmail();
            boolean emailVerified = payload.getEmailVerified();
            String name = (String)payload.get("name");
            String userId = name.replaceAll("\\s+", "") + "@go";
            String familyName = (String)payload.get("family_name");
            String givenName = (String)payload.get("given_name");
            Result<String> resultUser = PortalClient.getUserByEmail(email, config.getBootstrapToken());
            if (resultUser.isSuccess()) {
                map = JsonMapper.string2Map(resultUser.getResult());
                id = (String)map.get("userId");
                if (logger.isTraceEnabled()) {
                    logger.trace("userId from query service: " + (String)id + " userId from google: " + userId);
                }
                if (!userId.equals(id)) {
                    this.setExchangeStatus(exchange, EMAIL_REGISTERED, email, id);
                    return;
                }
            } else {
                map = new HashMap();
                map.put("host", "lightapi.net");
                map.put("email", email);
                map.put("userId", userId);
                map.put("language", "en");
                map.put("firstName", givenName);
                map.put("lastName", familyName);
                id = PortalClient.createSocialUser(map, config.getBootstrapToken());
            }
            String csrf = Util.getUUID();
            ClientAuthenticatedUserRequest request = new ClientAuthenticatedUserRequest("social", email, "user");
            request.setCsrf(csrf);
            Result<TokenResponse> result = OauthHelper.getTokenResult(request);
            if (result.isFailure()) {
                Status status = result.getError();
                exchange.setStatusCode(status.getStatusCode());
                exchange.getResponseSender().send(status.toString());
                logger.error(status.toString());
                return;
            }
            List<String> scopes = this.setCookies(exchange, result.getResult(), csrf);
            if (config.getRedirectUri() != null && config.getRedirectUri().length() > 0) {
                exchange.setStatusCode(200);
                HashMap<String, Object> rs = new HashMap<String, Object>();
                rs.put("scopes", scopes);
                rs.put("redirectUri", GoogleAuthHandler.config.redirectUri);
                rs.put("denyUri", GoogleAuthHandler.config.denyUri != null ? GoogleAuthHandler.config.denyUri : GoogleAuthHandler.config.redirectUri);
                exchange.getResponseSender().send(JsonMapper.toJson(rs));
            } else {
                exchange.setStatusCode(200);
                exchange.endExchange();
            }
        }
    }
}

