/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.SerializationOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ListOverlay<V>
extends JsonOverlay<List<V>> {
    private final OverlayFactory<V> itemFactory;
    private List<JsonOverlay<V>> overlays = new ArrayList<JsonOverlay<V>>();
    private boolean elaborated = false;

    private ListOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<List<V>> factory, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
        this.itemFactory = ((ListOverlayFactory)factory).getItemFactory();
    }

    private ListOverlay(List<V> value, JsonOverlay<?> parent, OverlayFactory<List<V>> factory, ReferenceManager refMgr) {
        super(new ArrayList<V>(value), parent, factory, refMgr);
        this.itemFactory = ((ListOverlayFactory)factory).getItemFactory();
    }

    @Override
    protected JsonOverlay<?> _findInternal(JsonPointer path) {
        int index = path.getMatchingIndex();
        return index >= 0 && this.overlays.size() > index ? this.overlays.get(index)._find(path.tail()) : null;
    }

    @Override
    protected List<V> _fromJson(JsonNode json) {
        return new ArrayList<V>(){
            private static final long serialVersionUID = 1L;

            public ListOverlay<V> getOverlay() {
                return ListOverlay.this;
            }
        };
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        ArrayNode array = ListOverlay._jsonArray();
        for (JsonOverlay<V> item : this.overlays) {
            array.add(item._toJson(options.plus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return array.size() > 0 || options.isKeepThisEmpty() ? array : ListOverlay._jsonMissing();
    }

    @Override
    protected boolean _isElaborated() {
        return this.elaborated;
    }

    @Override
    protected void _elaborate(boolean atCreation) {
        if (this.json != null) {
            this.fillWithJson();
        } else {
            this.fillWithValues();
        }
        this._setChildParentPaths();
        this.elaborated = true;
    }

    private void fillWithJson() {
        ((List)this.value).clear();
        this.overlays.clear();
        Iterator<JsonNode> iter = this.json.elements();
        while (iter.hasNext()) {
            JsonOverlay<V> itemOverlay = this.itemFactory.create(iter.next(), (JsonOverlay<?>)this, this.refMgr);
            this.overlays.add(itemOverlay);
            ((List)this.value).add(itemOverlay._get(false));
        }
    }

    private void fillWithValues() {
        this.overlays.clear();
        for (Object itemValue : (List)this.value) {
            this.overlays.add(this.itemOverlayFor(itemValue));
        }
    }

    private JsonOverlay<V> itemOverlayFor(V itemValue) {
        return this.itemFactory.create(itemValue, this, this.refMgr);
    }

    public V get(int index) {
        JsonOverlay<V> valOverlay = this.overlays.get(index);
        return valOverlay != null ? (V)valOverlay._get() : null;
    }

    JsonOverlay<V> _getOverlay(int index) {
        return this.overlays.get(index);
    }

    public void set(int index, V itemValue) {
        ((List)this.value).set(index, itemValue);
        this.overlays.set(index, this.itemOverlayFor(itemValue));
        this._setChildParentPath(index);
    }

    public void add(V itemValue) {
        ((List)this.value).add(itemValue);
        this.overlays.add(this.itemOverlayFor(itemValue));
        this._setChildParentPath(this.overlays.size() - 1);
    }

    public void insert(int index, V itemValue) {
        ((List)this.value).add(index, itemValue);
        this.overlays.add(index, this.itemOverlayFor(itemValue));
        this._setChildParentPaths(index, this.overlays.size());
    }

    public void remove(int index) {
        ((List)this.value).remove(index);
        this.overlays.remove(index);
        this._setChildParentPaths(index, this.overlays.size());
    }

    public int size() {
        return this.overlays.size();
    }

    private void _setChildParentPaths() {
        this._setChildParentPaths(0, this.overlays.size());
    }

    private void _setChildParentPath(int index) {
        this._setChildParentPaths(index, index + 1);
    }

    private void _setChildParentPaths(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.overlays.get(i)._setPathInParent(Integer.toString(i));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ListOverlay) {
            ListOverlay castObj = (ListOverlay)obj;
            return this.overlays.equals(castObj.overlays);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.overlays.hashCode();
    }

    public static <V> OverlayFactory<List<V>> getFactory(OverlayFactory<V> itemFactory) {
        return new ListOverlayFactory<V>(itemFactory);
    }

    @Override
    protected OverlayFactory<List<V>> _getFactory() {
        return this.factory;
    }

    private static class ListOverlayFactory<V>
    extends OverlayFactory<List<V>> {
        private final OverlayFactory<V> itemFactory;

        public ListOverlayFactory(OverlayFactory<V> itemFactory) {
            this.itemFactory = itemFactory;
        }

        @Override
        public String getSignature() {
            return String.format("list[%s]", this.itemFactory.getSignature());
        }

        @Override
        protected Class<? extends JsonOverlay<? super List<V>>> getOverlayClass() {
            Class<ListOverlay> overlayClass;
            Class<ListOverlay> castClass = overlayClass = ListOverlay.class;
            return castClass;
        }

        @Override
        protected JsonOverlay<List<V>> _create(List<V> value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new ListOverlay<V>(value, parent, this, refMgr);
        }

        @Override
        protected JsonOverlay<List<V>> _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new ListOverlay(json, parent, this, refMgr);
        }

        public OverlayFactory<V> getItemFactory() {
            return this.itemFactory;
        }
    }
}

