/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ResolutionException;
import java.io.IOException;
import java.util.HashSet;

public class Reference {
    private String refString;
    private String normalizedRef;
    private JsonPointer pointer = null;
    private ReferenceManager manager;
    private JsonNode json = null;
    private Boolean valid = null;
    private ResolutionException invalidReason = null;

    public Reference(String refString, String fragment, String normalizedRef, ReferenceManager manager) {
        this.refString = refString;
        this.normalizedRef = normalizedRef;
        this.manager = manager;
        try {
            this.pointer = fragment != null ? JsonPointer.compile(fragment) : null;
        }
        catch (IllegalArgumentException e) {
            this.valid = false;
            this.invalidReason = new ResolutionException("Invalid JSON pointer in JSON reference", this, e);
        }
    }

    public Reference(String refString, ResolutionException invalidReason, ReferenceManager manager) {
        this.refString = refString;
        this.invalidReason = invalidReason;
        this.manager = manager;
    }

    public static boolean isReferenceNode(JsonNode node) {
        return node.isObject() && node.has("$ref") && node.get("$ref").isTextual();
    }

    public String getRefString() {
        return this.refString;
    }

    public String getFragment() {
        return this.pointer != null ? this.pointer.toString() : "";
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isValid(boolean resolve) {
        if (resolve) {
            this.resolve();
        }
        return this.isResolved() && this.valid != false;
    }

    public boolean isInvalid() {
        return this.isInvalid(true);
    }

    public boolean isInvalid(boolean resolve) {
        if (resolve) {
            this.resolve();
        }
        return this.isResolved() && this.valid == false;
    }

    public ResolutionException getInvalidReason() {
        return this.invalidReason;
    }

    public boolean isResolved() {
        return this.valid != null;
    }

    public JsonNode getJson() {
        this.resolve();
        return this.json;
    }

    public String getNormalizedRef() {
        return this.normalizedRef;
    }

    public ReferenceManager getManager() {
        return this.manager;
    }

    public boolean resolve() {
        HashSet<String> visited = new HashSet<String>();
        Reference current = this;
        while (this.valid == null) {
            String normalized = current.getNormalizedRef();
            if (visited.contains(normalized)) {
                return this.failResolve(null, new ResolutionException.ReferenceCycleException(this, current));
            }
            visited.add(normalized);
            JsonNode currentJson = null;
            try {
                currentJson = current.getManager().loadDoc();
            }
            catch (IOException e) {
                return this.failResolve("Failed to load referenced documnet", e);
            }
            JsonNode jsonNode = currentJson = current.pointer != null ? currentJson.at(current.pointer) : currentJson;
            if (Reference.isReferenceNode(currentJson)) {
                current = this.manager.getReference(currentJson);
                if (!current.isInvalid(false)) continue;
                return this.failResolve("Invalid reference in reference chain", current.getInvalidReason());
            }
            this.json = currentJson;
            if (this.json.isMissingNode()) {
                this.failResolve("Referenced node not present in JSON document");
            }
            this.valid = true;
        }
        return this.isValid(false);
    }

    private boolean failResolve(String msg) {
        return this.failResolve(msg, null);
    }

    private boolean failResolve(String msg, Exception e) {
        this.valid = false;
        this.invalidReason = e instanceof ResolutionException && msg == null ? (ResolutionException)e : new ResolutionException(msg, this, e);
        return false;
    }
}

