/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.parameter.CookieHelper;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.openapi.parameter.ValueType;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CookieParameterDeserializer
implements ParameterDeserializer {
    private static final String FORM = "form";

    @Override
    public AttachmentKey<Map<String, Object>> getAttachmentKey() {
        return OpenApiHandler.DESERIALIZED_COOKIE_PARAMETERS;
    }

    @Override
    public StyleParameterDeserializer getStyleDeserializer(String style) {
        if (StringUtils.isNotBlank(style) && !FORM.equalsIgnoreCase(style)) {
            return null;
        }
        return new StyleParameterDeserializer(){

            @Override
            public boolean isApplicable(ValueType valueType, boolean exploade) {
                return !exploade || StyleParameterDeserializer.super.isApplicable(valueType, exploade);
            }

            @Override
            public Object deserialize(HttpServerExchange exchange, Parameter parameter, ValueType valueType, boolean exploade) {
                HeaderValues rawCookies = exchange.getRequestHeaders().get(Headers.COOKIE);
                Map<String, Cookie> cookies = CookieHelper.parseRequestCookies(exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_COOKIES, 200), exchange.getConnection().getUndertowOptions().get(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, false), rawCookies);
                Cookie cookie = cookies.get(parameter.getName());
                String value = cookie.getValue();
                if (ValueType.ARRAY == valueType) {
                    ArrayList<String> valueList = new ArrayList<String>();
                    valueList.addAll(this.asList(value, ","));
                    return valueList;
                }
                if (ValueType.OBJECT == valueType) {
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.putAll(this.asMap(value, ","));
                    return valueMap;
                }
                return null;
            }
        };
    }
}

