/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.openapi.parameter.ValueType;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HeaderParameterDeserializer
implements ParameterDeserializer {
    private static final String SIMPLE = "simple";

    @Override
    public AttachmentKey<Map<String, Object>> getAttachmentKey() {
        return OpenApiHandler.DESERIALIZED_HEADER_PARAMETERS;
    }

    @Override
    public StyleParameterDeserializer getStyleDeserializer(String style) {
        if (StringUtils.isNotBlank(style) && !SIMPLE.equalsIgnoreCase(style)) {
            return null;
        }
        return new StyleParameterDeserializer(){

            @Override
            public Object deserialize(HttpServerExchange exchange, Parameter parameter, ValueType valueType, boolean exploade) {
                HeaderValues values = exchange.getRequestHeaders().get(new HttpString(parameter.getName()));
                if (ValueType.ARRAY == valueType) {
                    ArrayList valueList = new ArrayList();
                    values.forEach(v -> valueList.addAll(this.asList((String)v, ",")));
                    return valueList;
                }
                if (ValueType.OBJECT == valueType) {
                    HashMap valueMap = new HashMap();
                    values.forEach(v -> valueMap.putAll(exploade ? this.asExploadeMap((String)v, ",") : this.asMap((String)v, ",")));
                    return valueMap;
                }
                return null;
            }
        };
    }
}

