/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.parameter.ParameterType;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface ParameterDeserializer {
    public static Set<String> getCandidateQueryParams(HttpServerExchange exchange) {
        HashSet<String> candidateQueryParams = new HashSet<String>();
        exchange.getQueryParameters().keySet().forEach(key -> {
            if (!key.contains("[")) {
                candidateQueryParams.add((String)key);
            } else {
                candidateQueryParams.add(key.substring(0, key.indexOf("[")));
            }
        });
        return candidateQueryParams;
    }

    public static void deserialize(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Set<String> candidateQueryParams = ParameterDeserializer.getCandidateQueryParams(exchange);
        Set<String> candidatePathParams = exchange.getPathParameters().keySet();
        Set candidateHeaderParams = exchange.getRequestHeaders().getHeaderNames().stream().map(name -> name.toString()).collect(Collectors.toSet());
        Set<String> candidateCookieParams = exchange.getRequestCookies().keySet();
        openApiOperation.getOperation().getParameters().forEach(p -> {
            ParameterType type = ParameterType.of(p.getIn());
            if (null != type) {
                ParameterDeserializer deserializer = type.getDeserializer();
                switch (type) {
                    case QUERY: {
                        deserializer.deserialize(exchange, (Parameter)p, candidateQueryParams);
                        break;
                    }
                    case PATH: {
                        deserializer.deserialize(exchange, (Parameter)p, candidatePathParams);
                        break;
                    }
                    case HEADER: {
                        deserializer.deserialize(exchange, (Parameter)p, candidateHeaderParams);
                        break;
                    }
                    case COOKIE: {
                        deserializer.deserialize(exchange, (Parameter)p, candidateCookieParams);
                    }
                }
            }
        });
    }

    default public boolean isApplicable(HttpServerExchange exchange, Parameter parameter, Set<String> candidateParams) {
        if (ParameterType.of(parameter.getIn()) == ParameterType.HEADER) {
            return candidateParams.stream().anyMatch(s -> parameter.getName().equalsIgnoreCase((String)s));
        }
        return candidateParams.contains(parameter.getName());
    }

    default public void deserialize(HttpServerExchange exchange, Parameter parameter, Set<String> candidateParams) {
        if (!this.isApplicable(exchange, parameter, candidateParams)) {
            return;
        }
        StyleParameterDeserializer deserializer = this.getStyleDeserializer(parameter.getStyle());
        if (null == deserializer) {
            return;
        }
        Object valueObj = deserializer.deserialize(exchange, parameter);
        if (null != valueObj) {
            this.attach(exchange, parameter.getName(), valueObj);
        }
    }

    public StyleParameterDeserializer getStyleDeserializer(String var1);

    default public AttachmentKey<Map<String, Object>> getAttachmentKey() {
        return null;
    }

    default public void attach(HttpServerExchange exchange, String key, Object value) {
        AttachmentKey<Map<String, Object>> paramType = this.getAttachmentKey();
        if (null != paramType) {
            this.attach(exchange, paramType, key, value);
        }
    }

    default public void attach(HttpServerExchange exchange, AttachmentKey<Map<String, Object>> paramType, String key, Object value) {
        Map<String, Object> paramMap = exchange.getAttachment(paramType);
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>();
            exchange.putAttachment(paramType, paramMap);
        }
        paramMap.put(key, value);
    }
}

