/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.openapi.parameter.QueryParameterStyle;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.openapi.parameter.ValueType;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Map;
import java.util.Set;

public class QueryParameterDeserializer
implements ParameterDeserializer {
    @Override
    public AttachmentKey<Map<String, Object>> getAttachmentKey() {
        return OpenApiHandler.DESERIALIZED_QUERY_PARAMETERS;
    }

    @Override
    public StyleParameterDeserializer getStyleDeserializer(String style) {
        QueryParameterStyle styleDef = QueryParameterStyle.of(style);
        if (null == styleDef) {
            return null;
        }
        return styleDef.getDeserializer();
    }

    @Override
    public boolean isApplicable(HttpServerExchange exchange, Parameter parameter, Set<String> candidateParams) {
        if (!candidateParams.contains(parameter.getName())) {
            QueryParameterStyle style = QueryParameterStyle.of(parameter.getStyle());
            ValueType valueType = StyleParameterDeserializer.getValueType(parameter);
            return ValueType.OBJECT == valueType && parameter.isExplode() && QueryParameterStyle.FORM == style && null != parameter.getSchema().getProperties() && parameter.getSchema().getProperties().keySet().stream().filter(prop -> candidateParams.contains(prop)).findAny().isPresent();
        }
        return true;
    }
}

