/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry;

public enum URLParamType {
    environment("environment", "production"),
    version("version", "1.0"),
    requestTimeout("requestTimeout", 200),
    requestIdFromClient("requestIdFromClient", 0),
    connectTimeout("connectTimeout", 1000),
    minWorkerThread("minWorkerThread", 20),
    maxWorkerThread("maxWorkerThread", 200),
    minClientConnection("minClientConnection", 2),
    maxClientConnection("maxClientConnection", 10),
    maxContentLength("maxContentLength", 0xA00000),
    maxServerConnection("maxServerConnection", 100000),
    poolLifo("poolLifo", true),
    lazyInit("lazyInit", false),
    shareChannel("shareChannel", false),
    serialize("serialization", "hessian2"),
    codec("codec", "light"),
    endpointFactory("endpointFactory", "light"),
    heartbeatFactory("heartbeatFactory", "light"),
    switcherService("switcherService", "localSwitcherService"),
    group("group", "default"),
    clientGroup("clientGroup", "default"),
    accessLog("accessLog", false),
    actives("actives", 0),
    refreshTimestamp("refreshTimestamp", 0),
    nodeType("nodeType", "service"),
    export("export", ""),
    embed("embed", ""),
    registryRetryPeriod("registryRetryPeriod", 30000),
    cluster("cluster", "default"),
    loadbalance("loadbalance", "activeWeight"),
    haStrategy("haStrategy", "failover"),
    protocol("protocol", "light"),
    path("path", ""),
    host("host", ""),
    port("port", 0),
    iothreads("iothreads", Runtime.getRuntime().availableProcessors() + 1),
    workerQueueSize("workerQueueSize", 0),
    acceptConnections("acceptConnections", 0),
    filter("filter", ""),
    application("application", "light"),
    module("module", "light"),
    retries("retries", 0),
    async("async", false),
    mock("mock", "false"),
    mean("mean", "2"),
    p90("p90", "4"),
    p99("p99", "10"),
    p999("p999", "70"),
    errorRate("errorRate", "0.01"),
    check("check", "true"),
    directUrl("directUrl", ""),
    registrySessionTimeout("registrySessionTimeout", 60000),
    register("register", true),
    subscribe("subscribe", true),
    throwException("throwException", "true"),
    localServiceAddress("localServiceAddress", ""),
    weights("weights", "");

    private final String name;
    private final String value;
    private final long longValue;
    private final int intValue;
    private final boolean boolValue;

    private URLParamType(String name, String value) {
        this.name = name;
        this.value = value;
        this.longValue = 0L;
        this.intValue = 0;
        this.boolValue = false;
    }

    private URLParamType(String name, long longValue) {
        this.name = name;
        this.value = String.valueOf(longValue);
        this.longValue = longValue;
        this.intValue = 0;
        this.boolValue = false;
    }

    private URLParamType(String name, int intValue) {
        this.name = name;
        this.value = String.valueOf(intValue);
        this.intValue = intValue;
        this.longValue = 0L;
        this.boolValue = false;
    }

    private URLParamType(String name, boolean boolValue) {
        this.name = name;
        this.value = String.valueOf(boolValue);
        this.boolValue = boolValue;
        this.longValue = 0L;
        this.intValue = 0;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public boolean getBooleanValue() {
        return this.boolValue;
    }
}

