/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.client.Http2Client;
import com.networknt.cluster.Cluster;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.HostWhitelist;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

@Deprecated
public class RouterProxyClient
implements ProxyClient {
    static Map<String, ClientConnection> connectionMap = new CopyOnWriteMap<String, ClientConnection>();
    static Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
    static Logger logger = LoggerFactory.getLogger(RouterProxyClient.class);
    private final Http2Client client = Http2Client.getInstance();
    private static final ProxyClient.ProxyTarget PROXY_TARGET = new ProxyClient.ProxyTarget(){};
    private static final HostWhitelist HOST_WHITELIST = new HostWhitelist();

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange httpServerExchange) {
        return PROXY_TARGET;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        String envTag;
        String key;
        ClientConnection existing;
        HeaderMap headers = exchange.getRequestHeaders();
        String serviceId = headers.getFirst(HttpStringConstants.SERVICE_ID);
        String serviceUrl = headers.getFirst(HttpStringConstants.SERVICE_URL);
        if (serviceUrl != null) {
            logger.debug(String.format("Found %s in request header: %s", "service_url", serviceUrl));
        }
        if ((existing = connectionMap.get(key = (serviceUrl != null ? serviceUrl : serviceId) + (envTag = headers.getFirst(HttpStringConstants.ENV_TAG)))) != null) {
            if (existing.isOpen()) {
                callback.completed(exchange, new ProxyConnection(existing, "/"));
                return;
            }
            connectionMap.remove(key);
        }
        String host = serviceUrl != null ? serviceUrl : cluster.serviceToUrl("https", serviceId, envTag, null);
        try {
            URI uri = new URI(host);
            if (serviceUrl != null) {
                if (HOST_WHITELIST != null) {
                    if (HOST_WHITELIST.isHostAllowed(uri)) {
                        this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(callback, exchange), uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
                    } else {
                        exchange.setReasonPhrase(String.format("Route to %s is not allowed in the host whitelist", serviceUrl));
                        callback.failed(exchange);
                    }
                } else {
                    exchange.setReasonPhrase(String.format("Host Whitelist must be enabled to support route based on %s in Http header", HttpStringConstants.SERVICE_URL));
                    callback.failed(exchange);
                }
            } else {
                this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(callback, exchange), uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            }
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI:" + host, e);
            exchange.setReasonPhrase("Invalid URI:" + host);
            callback.failed(exchange);
        }
    }

    private static final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final ProxyCallback<ProxyConnection> callback;
        private final HttpServerExchange exchange;

        private ConnectNotifier(ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void completed(ClientConnection connection) {
            if (logger.isDebugEnabled()) {
                logger.debug("ConnectNotifier completed is called with connection " + connection);
            }
            HeaderMap headers = this.exchange.getRequestHeaders();
            String serviceId = headers.getFirst(HttpStringConstants.SERVICE_ID);
            String serviceUrl = headers.getFirst(HttpStringConstants.SERVICE_URL);
            String envTag = headers.getFirst(HttpStringConstants.ENV_TAG);
            if (serviceId != null || serviceUrl != null) {
                String key = (serviceUrl != null ? serviceUrl : serviceId) + envTag;
                connectionMap.put(key, connection);
            }
            this.callback.completed(this.exchange, new ProxyConnection(connection, "/"));
        }

        @Override
        public void failed(IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("ConnectNotifier failed is called with exception", e);
            }
            this.callback.failed(this.exchange);
        }
    }
}

