/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.HandlerUtils;
import com.networknt.router.middleware.TokenHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPrefixServiceHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "pathPrefixService";
    public static final String ENABLED = "enabled";
    public static final String MAPPING = "mapping";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("pathPrefixService");
    public static Map<String, String> mapping = (Map)config.get("mapping");
    static Logger logger = LoggerFactory.getLogger(PathPrefixServiceHandler.class);
    private volatile HttpHandler next;
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";

    public PathPrefixServiceHandler() {
        logger.info("PathServiceHandler is constructed");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId;
        HeaderValues serviceIdHeader = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID);
        String string = serviceId = serviceIdHeader != null ? serviceIdHeader.peekFirst() : null;
        if (serviceId == null) {
            String requestPath = exchange.getRequestURI();
            serviceId = HandlerUtils.findServiceId(HandlerUtils.normalisePath(requestPath), mapping);
            if (serviceId == null) {
                this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, requestPath);
                return;
            }
            exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceId);
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(TokenHandler.class.getName(), config, null);
    }
}

