/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioUtils {
    private static final int BUFFER_SIZE = 4096;
    static final Logger logger = LoggerFactory.getLogger(NioUtils.class);

    private static FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = Paths.get(zipFilename, new String[0]);
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void unzip(String zipFilename, String destDirname) throws IOException {
        final Path destDir = Paths.get(destDirname, new String[0]);
        if (Files.notExists(destDir, new LinkOption[0])) {
            if (logger.isDebugEnabled()) {
                logger.debug(destDir + " does not exist. Creating...");
            }
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = NioUtils.createZipFileSystem(zipFilename, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Extracting file %s to %s", (Object)file, (Object)destFile);
                    }
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Creating directory %s", (Object)dirToCreate);
                        }
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void create(String zipFilename, String ... filenames) throws IOException {
        try (final FileSystem zipFileSystem = NioUtils.createZipFileSystem(zipFilename, true);){
            final Path root = zipFileSystem.getPath("/", new String[0]);
            for (String filename : filenames) {
                Path src = Paths.get(filename, new String[0]);
                if (!Files.isDirectory(src, new LinkOption[0])) {
                    Path dest = zipFileSystem.getPath(root.toString(), src.toString());
                    Path parent = dest.getParent();
                    if (Files.notExists(parent, new LinkOption[0])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Creating directory %s", (Object)parent);
                        }
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path dest = zipFileSystem.getPath(root.toString(), file.toString());
                        Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = zipFileSystem.getPath(root.toString(), dir.toString());
                        if (Files.notExists(dirToCreate, new LinkOption[0])) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Creating directory %s\n", (Object)dirToCreate);
                            }
                            Files.createDirectories(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    public static void list(String zipFilename) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Listing Archive:  %s", (Object)zipFilename);
        }
        try (FileSystem zipFileSystem = NioUtils.createZipFileSystem(zipFilename, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    this.print(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.print(dir);
                    return FileVisitResult.CONTINUE;
                }

                private void print(Path file) throws IOException {
                    SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss");
                    String modTime = df.format(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
                    if (logger.isDebugEnabled()) {
                        logger.debug("%d  %s  %s", Files.size(file), modTime, file);
                    }
                }
            });
        }
    }

    public static void deleteOldFiles(String dirPath, int olderThanMinute) {
        File folder = new File(dirPath);
        if (folder.exists()) {
            File[] listFiles = folder.listFiles();
            long eligibleForDeletion = System.currentTimeMillis() - (long)(olderThanMinute * 60) * 1000L;
            for (File listFile : listFiles) {
                if (listFile.lastModified() >= eligibleForDeletion || listFile.delete()) continue;
                logger.error("Unable to delete file %s", (Object)listFile);
            }
        }
    }

    public static ByteBuffer toByteBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteBuffer toByteBuffer(File file) {
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)file.length());
        try {
            buffer.put(NioUtils.toByteArray(new FileInputStream(file)));
        }
        catch (IOException e) {
            logger.error("Failed to write file to byte array: " + e.getMessage());
        }
        buffer.flip();
        return buffer;
    }

    public static String getTempDir() {
        String tempDir = System.getProperty("user.home");
        try {
            File temp = File.createTempFile("A0393939", ".tmp");
            String absolutePath = temp.getAbsolutePath();
            tempDir = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(NioUtils.toByteArray(is), StandardCharsets.UTF_8);
    }
}

