/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import com.networknt.config.Config;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsUtil {
    static final Logger logger = LoggerFactory.getLogger(TlsUtil.class);

    public static KeyStore loadKeyStore(String name, char[] password) {
        KeyStore keyStore;
        block10: {
            InputStream stream = Config.getInstance().getInputStreamFromFile(name);
            try {
                if (stream == null) {
                    String message = "Unable to load keystore '" + name + "', please provide the keystore matching the configuration in client.yml/server.yml to enable TLS connection.";
                    if (logger.isErrorEnabled()) {
                        logger.error(message);
                    }
                    throw new RuntimeException(message);
                }
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, password);
                keyStore = loadedKeystore;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Unable to load keystore " + name, e);
                    throw new RuntimeException("Unable to load keystore " + name, e);
                }
            }
            stream.close();
        }
        return keyStore;
    }

    public static KeyStore loadTrustStore(String name, char[] password) {
        KeyStore keyStore;
        block10: {
            InputStream stream = Config.getInstance().getInputStreamFromFile(name);
            try {
                if (stream == null) {
                    String message = "Unable to load truststore '" + name + "', please provide the truststore matching the configuration in client.yml/server.yml to enable TLS connection.";
                    if (logger.isErrorEnabled()) {
                        logger.error(message);
                    }
                    throw new RuntimeException(message);
                }
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, password);
                keyStore = loadedKeystore;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Unable to load truststore " + name, e);
                    throw new RuntimeException("Unable to load truststore " + name, e);
                }
            }
            stream.close();
        }
        return keyStore;
    }
}

