/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.util.UrlUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

abstract class BaseFacebookClient {
    protected WebRequestor webRequestor;
    protected JsonMapper jsonMapper;
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String FORMAT_PARAM_NAME = "format";
    private final Set<String> illegalParamNames = new HashSet<String>();
    protected static final String ACCESS_TOKEN_PARAM_NAME = "access_token";
    protected static final String APP_SECRET_PROOF_PARAM_NAME = "appsecret_proof";

    BaseFacebookClient() {
        this.illegalParamNames.add(ACCESS_TOKEN_PARAM_NAME);
        this.illegalParamNames.add(METHOD_PARAM_NAME);
        this.illegalParamNames.add(FORMAT_PARAM_NAME);
    }

    protected Parameter[] parametersWithAdditionalParameter(Parameter parameter, Parameter ... parameters) {
        Parameter[] parameterArray = Arrays.copyOf(parameters, parameters.length + 1);
        parameterArray[parameters.length] = parameter;
        return parameterArray;
    }

    protected String urlEncodedValueForParameterName(String name, String value) {
        return ACCESS_TOKEN_PARAM_NAME.equals(name) && value.contains("%7C") ? value : UrlUtils.urlEncode(value);
    }

    protected abstract String createEndpointForApiCall(String var1, boolean var2);

    protected void verifyParameterLegality(Parameter ... parameters) {
        Stream.of(parameters).map(parameter -> parameter.name).filter(this.illegalParamNames::contains).findAny().ifPresent(this::throwIAE);
    }

    private void throwIAE(String name) {
        throw new IllegalArgumentException("Parameter '" + name + "' is reserved for RestFB use - you cannot specify it yourself.");
    }
}

